/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.map;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.amygdalum.util.bits.BitSet;
import net.amygdalum.util.map.TuneableMap;

public class BitSetObjectMap<T>
extends TuneableMap {
    private static final BitSet NULL_KEY = null;
    private float loadFactor;
    private int mask;
    private int expandAt;
    private int size;
    private BitSet[] keys;
    private T[] values;
    private T defaultValue;
    private T nullValue;

    public BitSetObjectMap(T defaultValue) {
        this(16, 0.7f, defaultValue);
    }

    public BitSetObjectMap(int initialSize, float loadFactor, T defaultValue) {
        this.loadFactor = loadFactor;
        this.mask = BitSetObjectMap.mask(initialSize, loadFactor);
        this.expandAt = initialSize;
        this.size = 0;
        this.keys = new BitSet[this.mask + 1];
        this.values = new Object[this.mask + 1];
        this.defaultValue = defaultValue;
        this.nullValue = defaultValue;
    }

    public int size() {
        int size = this.size;
        if (this.nullValue != this.defaultValue) {
            ++size;
        }
        return size;
    }

    public BitSet[] keys() {
        int size = this.size;
        if (this.nullValue != this.defaultValue) {
            ++size;
        }
        BitSet[] keys = new BitSet[size];
        int pos = 0;
        for (BitSet c : this.keys) {
            if (c == NULL_KEY || c == null) continue;
            keys[pos] = c;
            ++pos;
        }
        if (this.nullValue != this.defaultValue) {
            keys[pos] = NULL_KEY;
        }
        return keys;
    }

    public BitSetObjectMap<T> add(BitSet key, T value) {
        this.put(key, value);
        return this;
    }

    public void put(BitSet key, T value) {
        if (key == NULL_KEY) {
            this.nullValue = value;
            return;
        }
        int slot = this.hash(key.hashCode()) & this.mask;
        while (this.keys[slot] != NULL_KEY && this.keys[slot] != null && !this.keys[slot].equals(key)) {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == NULL_KEY) {
            ++this.size;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        if (this.size > this.expandAt) {
            this.expand(this.size * 2);
        }
    }

    public T get(BitSet key) {
        if (key == NULL_KEY) {
            return this.nullValue;
        }
        int slot = this.hash(key.hashCode()) & this.mask;
        while (this.keys[slot] != NULL_KEY && this.keys[slot] != null && !this.keys[slot].equals(key)) {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == NULL_KEY) {
            return this.defaultValue;
        }
        return this.values[slot];
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Iterable<Entry<T>> cursor() {
        return new EntryIterable(this);
    }

    private void expand(int size) {
        int i;
        int mask = BitSetObjectMap.mask(size, this.loadFactor);
        BitSet[] oldkeys = this.keys;
        T[] oldvalues = this.values;
        BitSet[] keys = new BitSet[mask + 1];
        Object[] values = new Object[mask + 1];
        int[] delayed = new int[this.size];
        int pos = 0;
        for (i = 0; i < oldkeys.length; ++i) {
            BitSet key = oldkeys[i];
            if (key == NULL_KEY || key == null) continue;
            T value = oldvalues[i];
            int slot = this.hash(key.hashCode()) & mask;
            if (keys[slot] == NULL_KEY || keys[slot] == null) {
                keys[slot] = key;
                values[slot] = value;
                continue;
            }
            delayed[pos] = i;
            ++pos;
        }
        for (i = 0; i < pos; ++i) {
            int j = delayed[i];
            BitSet key = oldkeys[j];
            T value = oldvalues[j];
            int slot = this.hash(key.hashCode()) & mask;
            while (keys[slot] != key && keys[slot] != NULL_KEY) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
        this.expandAt = size;
        this.mask = mask;
        this.keys = keys;
        this.values = values;
    }

    public String toString() {
        Entry<T> entry;
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        Iterator<Entry<T>> cursor = this.cursor().iterator();
        if (cursor.hasNext()) {
            entry = cursor.next();
            buffer.append(entry.toString());
        }
        while (cursor.hasNext()) {
            entry = cursor.next();
            buffer.append(",\n").append(entry.toString());
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    public static class Entry<T> {
        public BitSet key;
        public T value;

        public String toString() {
            String keystr = this.key == null ? "null" : "0b" + this.key.toString();
            return keystr + ':' + this.value;
        }
    }

    public static class EntryIterator<T>
    implements Iterator<Entry<T>> {
        private BitSetObjectMap<T> map;
        private int index;
        private int currentKey;
        private int fixedSize;
        private Entry<T> entry;

        public EntryIterator(BitSetObjectMap<T> map) {
            this.map = map;
            this.index = 0;
            this.currentKey = -1;
            this.fixedSize = ((BitSetObjectMap)map).size;
            this.entry = new Entry();
        }

        @Override
        public boolean hasNext() {
            if (((BitSetObjectMap)this.map).size != this.fixedSize) {
                throw new ConcurrentModificationException();
            }
            return this.index < this.fixedSize || this.index == this.fixedSize && ((BitSetObjectMap)this.map).nullValue != ((BitSetObjectMap)this.map).defaultValue;
        }

        @Override
        public Entry<T> next() {
            if (((BitSetObjectMap)this.map).size != this.fixedSize) {
                throw new ConcurrentModificationException();
            }
            while (this.currentKey < ((BitSetObjectMap)this.map).keys.length - 1) {
                ++this.currentKey;
                BitSet b = ((BitSetObjectMap)this.map).keys[this.currentKey];
                if (b == NULL_KEY) continue;
                this.entry.key = ((BitSetObjectMap)this.map).keys[this.currentKey];
                this.entry.value = ((BitSetObjectMap)this.map).values[this.currentKey];
                ++this.index;
                return this.entry;
            }
            if (((BitSetObjectMap)this.map).nullValue != ((BitSetObjectMap)this.map).defaultValue) {
                this.entry.key = NULL_KEY;
                this.entry.value = ((BitSetObjectMap)this.map).nullValue;
                ++this.index;
                return this.entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentKey < 0) {
                throw new NoSuchElementException();
            }
            if (((BitSetObjectMap)this.map).keys[this.currentKey] != NULL_KEY) {
                ((BitSetObjectMap)this.map).size--;
            } else if (((BitSetObjectMap)this.map).values[this.currentKey] != ((BitSetObjectMap)this.map).defaultValue) {
                ((BitSetObjectMap)this.map).nullValue = ((BitSetObjectMap)this.map).defaultValue;
            }
            ((BitSetObjectMap)this.map).keys[this.currentKey] = NULL_KEY;
            ((BitSetObjectMap)this.map).values[this.currentKey] = ((BitSetObjectMap)this.map).defaultValue;
        }
    }

    public static class EntryIterable<T>
    implements Iterable<Entry<T>> {
        private BitSetObjectMap<T> map;

        public EntryIterable(BitSetObjectMap<T> map) {
            this.map = map;
        }

        @Override
        public Iterator<Entry<T>> iterator() {
            return new EntryIterator<T>(this.map);
        }
    }
}

