/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.text.ByteString;

public class StringByteProvider
implements ByteProvider {
    private static final int NO_MARK = -1;
    private Charset charset;
    private ByteBuffer encoded;
    private int mark;

    public StringByteProvider(String input, int start) {
        this(input, start, StandardCharsets.UTF_16LE);
    }

    public StringByteProvider(String input, int start, Charset charset) {
        this.encoded = StringByteProvider.encode(charset, input);
        this.charset = charset;
        this.encoded.position(start);
        this.mark = -1;
    }

    public StringByteProvider(byte[] input, int start, Charset charset) {
        this.encoded = ByteBuffer.wrap(input);
        this.charset = charset;
        this.encoded.position(start);
        this.mark = -1;
    }

    private static ByteBuffer encode(Charset charset, String str) {
        CharBuffer chars = CharBuffer.wrap(str);
        CharsetEncoder encoder = charset.newEncoder();
        try {
            return encoder.encode(chars);
        }
        catch (CharacterCodingException e) {
            return ByteBuffer.allocate(0);
        }
    }

    public void restart() {
        this.encoded.position(0);
    }

    @Override
    public void finish() {
        this.encoded.position(this.encoded.limit());
    }

    @Override
    public byte next() {
        return this.encoded.get();
    }

    @Override
    public byte lookahead() {
        return this.encoded.get(this.encoded.position());
    }

    @Override
    public byte lookahead(int i) {
        return this.encoded.get(this.encoded.position() + i);
    }

    @Override
    public byte prev() {
        int pos = this.encoded.position() - 1;
        this.encoded.position(pos);
        return this.encoded.get(pos);
    }

    @Override
    public byte lookbehind() {
        return this.encoded.get(this.encoded.position() - 1);
    }

    @Override
    public byte lookbehind(int i) {
        return this.encoded.get(this.encoded.position() - i - 1);
    }

    @Override
    public long current() {
        return this.encoded.position();
    }

    @Override
    public void move(long i) {
        this.encoded.position((int)i);
    }

    @Override
    public void forward(int i) {
        this.encoded.position(this.encoded.position() + i);
    }

    @Override
    public boolean finished() {
        return !this.encoded.hasRemaining();
    }

    @Override
    public boolean finished(int i) {
        return this.encoded.remaining() <= i;
    }

    @Override
    public byte at(long i) {
        return this.encoded.get((int)i);
    }

    @Override
    public byte[] between(long start, long end) {
        int len = (int)(end - start);
        byte[] between = new byte[len];
        if (len == 0) {
            return between;
        }
        int limit = this.encoded.limit();
        int pos = this.encoded.position();
        this.encoded.position((int)start);
        this.encoded.limit((int)end);
        this.encoded.get(between);
        this.encoded.position(pos);
        this.encoded.limit(limit);
        return between;
    }

    @Override
    public ByteString slice(long start, long end) {
        int limit = this.encoded.limit();
        int pos = this.encoded.position();
        this.encoded.position((int)start);
        this.encoded.limit((int)end);
        byte[] slice = new byte[(int)Math.max(0L, end - start)];
        this.encoded.get(slice);
        this.encoded.limit(limit);
        this.encoded.position(pos);
        return new ByteString(slice, this.charset);
    }

    public String toString() {
        long splitPoint;
        ByteString slice = this.slice(0L, splitPoint);
        StringBuilder buffer = new StringBuilder(slice.getMappablePrefix());
        if (!slice.isMappable()) {
            buffer.append("~|~");
            for (splitPoint = this.current(); splitPoint < (long)this.encoded.limit() && !this.slice(splitPoint, this.encoded.limit()).isMappable(); ++splitPoint) {
            }
        } else {
            buffer.append('|');
        }
        if (splitPoint < (long)this.encoded.limit()) {
            buffer.append(this.slice(splitPoint, this.encoded.limit()).getMappableSuffix());
        }
        return buffer.toString();
    }

    @Override
    public void mark() {
        this.mark = this.encoded.position();
    }

    @Override
    public boolean changed() {
        boolean changed = this.mark != -1 && this.mark != this.encoded.position();
        this.mark = -1;
        return changed;
    }
}

