/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.io;

import java.util.List;
import net.amygdalum.util.io.CharClassMapper;
import net.amygdalum.util.text.CharRange;
import net.amygdalum.util.text.CharUtils;

public class SmallRangeCharClassMapper
implements CharClassMapper {
    private char[] chars;
    private char lowerBound;
    private char upperBound;
    private int dead;
    private int[] charToClass;

    public SmallRangeCharClassMapper(List<CharRange> liveRanges) {
        this.lowerBound = (char)(liveRanges.isEmpty() ? 65535 : (int)liveRanges.get((int)0).from);
        this.upperBound = liveRanges.isEmpty() ? (char)'\u0000' : liveRanges.get((int)(liveRanges.size() - 1)).to;
        this.dead = SmallRangeCharClassMapper.deadClass(liveRanges);
        this.chars = SmallRangeCharClassMapper.chars(this.dead, liveRanges);
        this.charToClass = SmallRangeCharClassMapper.computeCharClasses(this.dead, liveRanges);
    }

    private static int deadClass(List<CharRange> liveRanges) {
        if (liveRanges.isEmpty()) {
            return 0;
        }
        char nextCandidate = '\u0000';
        for (CharRange range : liveRanges) {
            if (range.contains(nextCandidate)) {
                nextCandidate = CharUtils.after(range.to);
                continue;
            }
            return 0;
        }
        if (nextCandidate == CharUtils.after('\uffff')) {
            return -1;
        }
        return 0;
    }

    private static char[] chars(int dead, List<CharRange> liveRanges) {
        int liveIndex = dead + 1;
        char[] chars = new char[liveIndex + liveRanges.size()];
        if (dead == 0) {
            chars[dead] = SmallRangeCharClassMapper.deadChar(liveRanges);
        }
        for (CharRange range : liveRanges) {
            chars[liveIndex] = range.from;
            ++liveIndex;
        }
        return chars;
    }

    private static char deadChar(List<CharRange> liveRanges) {
        char nextCandidate = '\u0000';
        for (CharRange range : liveRanges) {
            if (range.contains(nextCandidate)) {
                nextCandidate = CharUtils.after(range.to);
                continue;
            }
            return nextCandidate;
        }
        if (nextCandidate == CharUtils.after('\uffff')) {
            return '\u0000';
        }
        return nextCandidate;
    }

    private static int[] computeCharClasses(int dead, List<CharRange> liveRanges) {
        if (liveRanges.isEmpty()) {
            return new int[0];
        }
        char low = liveRanges.get((int)0).from;
        char high = liveRanges.get((int)(liveRanges.size() - 1)).to;
        int[] charToClass = new int[high - low + 1];
        int charClass = dead + 1;
        for (CharRange range : liveRanges) {
            for (int i = range.from; i <= range.to; ++i) {
                charToClass[i - low] = charClass;
            }
            ++charClass;
        }
        return charToClass;
    }

    @Override
    public int getIndex(char ch) {
        if (ch < this.lowerBound || ch > this.upperBound) {
            return this.dead;
        }
        return this.charToClass[ch - this.lowerBound];
    }

    @Override
    public int indexCount() {
        return this.chars.length;
    }

    @Override
    public char representative(int i) {
        return this.chars[i];
    }

    @Override
    public char representative(char ch) {
        if (ch < this.lowerBound || ch > this.upperBound) {
            return this.chars[this.dead];
        }
        return this.chars[this.charToClass[ch - this.lowerBound]];
    }

    @Override
    public char[] representatives() {
        return this.chars;
    }
}

