/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.io;

import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.text.ByteString;

public class ReverseByteProvider
implements ByteProvider {
    private ByteProvider bytes;

    public ReverseByteProvider(ByteProvider bytes) {
        this.bytes = bytes;
    }

    @Override
    public byte next() {
        return this.bytes.prev();
    }

    @Override
    public byte lookahead() {
        return this.bytes.lookbehind();
    }

    @Override
    public byte lookahead(int i) {
        return this.bytes.lookbehind(i);
    }

    @Override
    public byte prev() {
        return this.bytes.next();
    }

    @Override
    public byte lookbehind() {
        return this.bytes.lookahead();
    }

    @Override
    public byte lookbehind(int i) {
        return this.bytes.lookahead(i);
    }

    @Override
    public long current() {
        return this.bytes.current();
    }

    @Override
    public void move(long i) {
        this.bytes.move(i);
    }

    @Override
    public void forward(int i) {
        this.bytes.forward(-i);
    }

    @Override
    public void finish() {
        this.bytes.move(0L);
    }

    @Override
    public byte at(long i) {
        return this.bytes.at(i);
    }

    @Override
    public boolean finished() {
        return this.bytes.current() == 0L;
    }

    @Override
    public boolean finished(int i) {
        return this.bytes.current() <= (long)i;
    }

    @Override
    public byte[] between(long start, long end) {
        byte[] between = this.bytes.between(end, start);
        int reverseStart = between.length - 1;
        for (int i = 0; i < between.length / 2; ++i) {
            byte temp = between[i];
            between[i] = between[reverseStart - i];
            between[reverseStart - i] = temp;
        }
        return between;
    }

    @Override
    public ByteString slice(long start, long end) {
        return this.bytes.slice(end, start).revert();
    }

    @Override
    public void mark() {
        this.bytes.mark();
    }

    @Override
    public boolean changed() {
        return this.bytes.changed();
    }

    public String toString() {
        return new StringBuilder(this.bytes.toString()).reverse().toString();
    }
}

