/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.io;

import java.util.Arrays;
import java.util.List;
import net.amygdalum.util.io.CharClassMapper;
import net.amygdalum.util.text.CharRange;
import net.amygdalum.util.text.CharUtils;

public final class LowByteCharClassMapper
implements CharClassMapper {
    private int dead;
    private char[] chars;
    private int[] lowbyte;

    public LowByteCharClassMapper(List<CharRange> liveRanges) {
        this.dead = LowByteCharClassMapper.deadClass(liveRanges);
        this.chars = LowByteCharClassMapper.chars(this.dead, liveRanges);
        this.lowbyte = LowByteCharClassMapper.computeLowByte(this.dead, liveRanges);
    }

    private static char[] chars(int dead, List<CharRange> liveRanges) {
        int liveIndex = dead + 1;
        char[] chars = new char[liveIndex + liveRanges.size()];
        if (dead == 0) {
            chars[dead] = LowByteCharClassMapper.deadChar(liveRanges);
        }
        for (CharRange range : liveRanges) {
            chars[liveIndex] = range.from;
            ++liveIndex;
        }
        return chars;
    }

    private static int deadClass(List<CharRange> liveRanges) {
        if (liveRanges.isEmpty()) {
            return 0;
        }
        char nextCandidate = (char)(liveRanges.get((int)0).from & 0xFF00);
        char lastCandidate = (char)(liveRanges.get((int)0).from | 0xFF);
        for (CharRange range : liveRanges) {
            if (range.contains(nextCandidate)) {
                nextCandidate = CharUtils.after(range.to);
                continue;
            }
            return 0;
        }
        if (nextCandidate > lastCandidate) {
            return -1;
        }
        return 0;
    }

    private static char deadChar(List<CharRange> liveRanges) {
        char nextCandidate = '\u0000';
        for (CharRange range : liveRanges) {
            if (range.contains(nextCandidate)) {
                nextCandidate = CharUtils.after(range.to);
                continue;
            }
            return nextCandidate;
        }
        if (nextCandidate == CharUtils.after('\uffff')) {
            return '\u0000';
        }
        return nextCandidate;
    }

    private static int[] computeLowByte(int dead, List<CharRange> liveRanges) {
        int[] lowbytes = new int[256];
        Arrays.fill(lowbytes, dead);
        int index = dead + 1;
        for (CharRange range : liveRanges) {
            for (int c = range.from; c <= range.to; ++c) {
                int low = c & 0xFF;
                lowbytes[low] = index;
            }
            ++index;
        }
        return lowbytes;
    }

    @Override
    public int getIndex(char ch) {
        int l = ch & 0xFF;
        return this.lowbyte[l];
    }

    @Override
    public int indexCount() {
        return this.chars.length;
    }

    @Override
    public char representative(int i) {
        return this.chars[i];
    }

    @Override
    public char representative(char ch) {
        int l = ch & 0xFF;
        return this.chars[this.lowbyte[l]];
    }

    @Override
    public char[] representatives() {
        return this.chars;
    }
}

