/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.io;

import java.util.Arrays;
import java.util.List;
import net.amygdalum.util.io.CharClassMapper;
import net.amygdalum.util.text.CharRange;
import net.amygdalum.util.text.CharUtils;

public final class BitMaskCharClassMapper
implements CharClassMapper {
    private int dead;
    private char[] chars;
    private int[][] bytes;

    public BitMaskCharClassMapper(List<CharRange> liveRanges) {
        this.dead = BitMaskCharClassMapper.deadClass(liveRanges);
        this.chars = BitMaskCharClassMapper.chars(this.dead, liveRanges);
        this.bytes = BitMaskCharClassMapper.computeBytes(this.dead, liveRanges);
    }

    private static char[] chars(int dead, List<CharRange> liveRanges) {
        int liveIndex = dead + 1;
        char[] chars = new char[liveIndex + liveRanges.size()];
        if (dead == 0) {
            chars[dead] = BitMaskCharClassMapper.deadChar(liveRanges);
        }
        for (CharRange range : liveRanges) {
            chars[liveIndex] = range.from;
            ++liveIndex;
        }
        return chars;
    }

    private static int deadClass(List<CharRange> liveRanges) {
        if (liveRanges.isEmpty()) {
            return 0;
        }
        char nextCandidate = '\u0000';
        for (CharRange range : liveRanges) {
            if (range.contains(nextCandidate)) {
                nextCandidate = CharUtils.after(range.to);
                continue;
            }
            return 0;
        }
        if (nextCandidate == CharUtils.after('\uffff')) {
            return -1;
        }
        return 0;
    }

    private static char deadChar(List<CharRange> liveRanges) {
        char nextCandidate = '\u0000';
        for (CharRange range : liveRanges) {
            if (range.contains(nextCandidate)) {
                nextCandidate = CharUtils.after(range.to);
                continue;
            }
            return nextCandidate;
        }
        if (nextCandidate == CharUtils.after('\uffff')) {
            return '\u0000';
        }
        return nextCandidate;
    }

    private static int[][] computeBytes(int dead, List<CharRange> liveRanges) {
        int[] deadbytes = new int[256];
        Arrays.fill(deadbytes, dead);
        int[][] bytes = new int[256][];
        Arrays.fill((Object[])bytes, deadbytes);
        int index = dead;
        for (CharRange range : liveRanges) {
            ++index;
            int lowFrom = range.from & 0xFF;
            int highFrom = range.from >> 8 & 0xFF;
            int lowTo = range.to & 0xFF;
            int highTo = range.to >> 8 & 0xFF;
            for (int i = highFrom; i <= highTo; ++i) {
                if (bytes[i] == deadbytes) {
                    bytes[i] = new int[256];
                    Arrays.fill(bytes[i], dead);
                }
                int start = i == highFrom ? lowFrom : 0;
                int end = i == highTo ? lowTo : 255;
                for (int j = start; j <= end; ++j) {
                    bytes[i][j] = index;
                }
            }
        }
        return bytes;
    }

    @Override
    public int getIndex(char ch) {
        int h = ch >> 8 & 0xFF;
        int l = ch & 0xFF;
        return this.bytes[h][l];
    }

    @Override
    public int indexCount() {
        return this.chars.length;
    }

    @Override
    public char representative(int i) {
        return this.chars[i];
    }

    @Override
    public char representative(char ch) {
        int h = ch >> 8 & 0xFF;
        int l = ch & 0xFF;
        return this.chars[this.bytes[h][l]];
    }

    @Override
    public char[] representatives() {
        return this.chars;
    }
}

