/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.builders;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.amygdalum.util.builders.Predicate;

public final class Sets<T> {
    private Set<T> set;

    private Sets(boolean linked) {
        this.set = linked ? new LinkedHashSet<T>() : new HashSet<T>();
    }

    private Sets(Collection<? extends T> set, boolean linked) {
        this.set = linked ? new LinkedHashSet<T>(set) : new HashSet<T>(set);
    }

    @SafeVarargs
    public static <T> Sets<T> linked(T ... elements) {
        if (elements.length == 0) {
            return new Sets<T>(true);
        }
        return new Sets<T>(Arrays.asList(elements), true);
    }

    public static <T> Sets<T> linked(Collection<T> set) {
        return new Sets<T>(set, true);
    }

    @SafeVarargs
    public static <T> Sets<T> hashed(T ... elements) {
        if (elements.length == 0) {
            return new Sets<T>(false);
        }
        return new Sets<T>(Arrays.asList(elements), false);
    }

    public static <T> Sets<T> hashed(Collection<T> set) {
        return new Sets<T>(set, false);
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <T> Set<T> of(Predicate<T> cond, T ... elements) {
        HashSet<T> list = new HashSet<T>();
        for (T element : elements) {
            if (!cond.evaluate(element)) continue;
            list.add(element);
        }
        return list;
    }

    @SafeVarargs
    public static <T> Set<T> ofLinked(T ... elements) {
        return new LinkedHashSet<T>(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <T> Set<T> ofLinked(Predicate<T> cond, T ... elements) {
        LinkedHashSet<T> list = new LinkedHashSet<T>();
        for (T element : elements) {
            if (!cond.evaluate(element)) continue;
            list.add(element);
        }
        return list;
    }

    public static Set<Integer> ofPrimitives(int ... array) {
        HashSet<Integer> set = new HashSet<Integer>(array.length);
        for (int i : array) {
            set.add(i);
        }
        return set;
    }

    public static Set<Integer> ofLinkedPrimitives(int ... array) {
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>(array.length);
        for (int i : array) {
            set.add(i);
        }
        return set;
    }

    public static <T> Set<T> intersectionOf(Set<T> set, Set<T> other) {
        return new Sets<T>(set, false).intersect(other).build();
    }

    public static <T> Set<T> unionOf(Set<T> set, Set<T> other) {
        return new Sets<T>(set, false).union(other).build();
    }

    public static <T> Set<T> complementOf(Set<T> set, Set<T> minus) {
        return new Sets<T>(set, false).minus(minus).build();
    }

    public Sets<T> union(Set<T> add) {
        return this.addAll(add);
    }

    public Sets<T> add(T add) {
        this.set.add(add);
        return this;
    }

    public Sets<T> addConditional(boolean b, T add) {
        if (b) {
            this.set.add(add);
        }
        return this;
    }

    public Sets<T> addAll(Set<T> add) {
        this.set.addAll(add);
        return this;
    }

    public Sets<T> addAll(T ... add) {
        this.set.addAll(Arrays.asList(add));
        return this;
    }

    public Sets<T> minus(Set<T> remove) {
        return this.removeAll(remove);
    }

    public Sets<T> remove(T remove) {
        this.set.remove(remove);
        return this;
    }

    public Sets<T> removeConditional(boolean b, T remove) {
        if (b) {
            this.set.remove(remove);
        }
        return this;
    }

    public Sets<T> removeAll(Set<T> remove) {
        this.set.removeAll(remove);
        return this;
    }

    public Sets<T> removeAll(T ... remove) {
        this.set.removeAll(Arrays.asList(remove));
        return this;
    }

    public Sets<T> intersect(Set<T> retain) {
        return this.retainAll(retain);
    }

    public Sets<T> retain(T retain) {
        HashSet<T> retainAll = new HashSet<T>();
        retainAll.add(retain);
        this.set.retainAll(retainAll);
        return this;
    }

    public Sets<T> retainConditional(boolean b, T retain) {
        if (b) {
            HashSet<T> retainAll = new HashSet<T>();
            retainAll.add(retain);
            this.set.retainAll(retainAll);
        }
        return this;
    }

    public Sets<T> retainAll(Set<T> retain) {
        this.set.retainAll(retain);
        return this;
    }

    public Sets<T> retainAll(T ... retain) {
        this.set.retainAll(Arrays.asList(retain));
        return this;
    }

    public Set<T> build() {
        return this.set;
    }
}

