/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.builders;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Maps<K, V> {
    private Map<K, V> map;

    private Maps(boolean linked) {
        this.map = linked ? new LinkedHashMap() : new HashMap();
    }

    public static <K, V> Maps<K, V> linked() {
        return new Maps<K, V>(true);
    }

    public static <K, V> Maps<K, V> hashed() {
        return new Maps<K, V>(false);
    }

    public Maps<K, V> put(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public static <K, V> Maps<K, V> invert(Map<V, K> toinvert) {
        Maps<K, V> maps = new Maps<K, V>(false);
        for (Map.Entry<V, K> entry : toinvert.entrySet()) {
            maps.put(entry.getValue(), entry.getKey());
        }
        return maps;
    }

    public Map<K, V> build() {
        return this.map;
    }
}

