/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.bits;

import java.util.Arrays;

public class BitSet
implements Cloneable {
    private final int size;
    private final int lastsize;
    private final long lastmask;
    private long[] bits;

    private BitSet(int size, long[] bits) {
        this.size = size;
        this.lastsize = (size - 1) % 64 + 1;
        this.lastmask = this.lastsize == 64 ? -1L : (1L << this.lastsize) - 1L;
        this.bits = bits;
    }

    public static BitSet bits(int size, int ... setbits) {
        long[] bits = BitSet.init(size);
        for (int setbit : setbits) {
            int index = setbit / 64;
            int offset = setbit % 64;
            int n = index;
            bits[n] = bits[n] | 1L << offset;
        }
        return new BitSet(size, bits);
    }

    public static BitSet ofLong(long ... bits) {
        return new BitSet(bits.length * 64, bits);
    }

    public static BitSet empty(int size) {
        return new BitSet(size, BitSet.init(size));
    }

    public static BitSet all(int size) {
        return new BitSet(size, BitSet.allBitsSet(size));
    }

    private static long[] allBitsSet(int size) {
        long[] bits = BitSet.init(size);
        int lastsize = (size - 1) % 64 + 1;
        long lastmask = lastsize == 64 ? -1L : (1L << lastsize) - 1L;
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = -1L;
        }
        int n = bits.length - 1;
        bits[n] = bits[n] & lastmask;
        return bits;
    }

    public int bitCount() {
        int bitCount = 0;
        for (int i = 0; i < this.bits.length; ++i) {
            bitCount += Long.bitCount(this.bits[i]);
        }
        return bitCount;
    }

    public int[] allClearBits() {
        int[] clearBits = new int[this.size - this.bitCount()];
        int index = 0;
        int next = 0;
        long value = this.bits[index] ^ 0xFFFFFFFFFFFFFFFFL;
        long mask = 1L;
        for (int i = 0; i < clearBits.length; ++i) {
            while ((mask & value) == 0L) {
                ++next;
                if ((mask <<= 1) != 0L) continue;
                if (++index >= this.bits.length) break;
                value = this.bits[index] ^ 0xFFFFFFFFFFFFFFFFL;
                mask = 1L;
            }
            clearBits[i] = next++;
            if ((mask <<= 1) != 0L) continue;
            if (++index >= this.bits.length) break;
            value = this.bits[index] ^ 0xFFFFFFFFFFFFFFFFL;
            mask = 1L;
        }
        return clearBits;
    }

    public int[] allSetBits() {
        int[] setBits = new int[this.bitCount()];
        int index = 0;
        int next = 0;
        long value = this.bits[index];
        long mask = 1L;
        for (int i = 0; i < setBits.length; ++i) {
            while ((mask & value) == 0L) {
                ++next;
                if ((mask <<= 1) != 0L) continue;
                if (++index >= this.bits.length) break;
                value = this.bits[index];
                mask = 1L;
            }
            setBits[i] = next++;
            if ((mask <<= 1) != 0L) continue;
            if (++index >= this.bits.length) break;
            value = this.bits[index];
            mask = 1L;
        }
        return setBits;
    }

    public int nextSetBit(int i) {
        if (i >= this.size) {
            return -1;
        }
        int index = i / 64;
        int start = i % 64;
        long value = this.bits[index];
        long mask = 1L << start;
        int next = i;
        while ((mask & value) == 0L) {
            ++next;
            if ((mask <<= 1) != 0L) continue;
            if (++index >= this.bits.length) break;
            value = this.bits[index];
            mask = 1L;
        }
        if (next >= this.size) {
            return -1;
        }
        return next;
    }

    public int nextClearBit(int i) {
        if (i >= this.size) {
            return -1;
        }
        int index = i / 64;
        int start = i % 64;
        long value = this.bits[index] ^ 0xFFFFFFFFFFFFFFFFL;
        long mask = 1L << start;
        int next = i;
        while ((mask & value) == 0L) {
            ++next;
            if ((mask <<= 1) != 0L) continue;
            if (++index >= this.bits.length) break;
            value = this.bits[index] ^ 0xFFFFFFFFFFFFFFFFL;
            mask = 1L;
        }
        if (next >= this.size) {
            return -1;
        }
        return next;
    }

    public int size() {
        return this.size;
    }

    public BitSet not() {
        long[] newbits = new long[this.bits.length];
        for (int i = 0; i < newbits.length; ++i) {
            newbits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n = newbits.length - 1;
        newbits[n] = newbits[n] & this.lastmask;
        return new BitSet(this.size, newbits);
    }

    public BitSet and(BitSet other) {
        int diff = this.bits.length - other.bits.length;
        int newsize = Math.max(this.size, other.size);
        long[] newbits = BitSet.init(newsize);
        int len = diff <= 0 ? this.bits.length : other.bits.length;
        for (int i = 0; i < len; ++i) {
            newbits[i] = this.bits[i] & other.bits[i];
        }
        return new BitSet(newsize, newbits);
    }

    public BitSet andNot(BitSet other) {
        int diff = this.bits.length - other.bits.length;
        int newsize = Math.max(this.size, other.size);
        int lastsize = (newsize - 1) % 64 + 1;
        long lastmask = lastsize == 64 ? -1L : (1L << lastsize) - 1L;
        long[] newbits = BitSet.init(newsize);
        int len = diff <= 0 ? this.bits.length : other.bits.length;
        for (int i = 0; i < len; ++i) {
            newbits[i] = this.bits[i] & (other.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (diff > 0) {
            System.arraycopy(this.bits, len, newbits, len, diff);
        }
        int n = newbits.length - 1;
        newbits[n] = newbits[n] & lastmask;
        return new BitSet(newsize, newbits);
    }

    public BitSet or(BitSet other) {
        int diff = this.bits.length - other.bits.length;
        int newsize = Math.max(this.size, other.size);
        long[] newbits = BitSet.init(newsize);
        int len = diff <= 0 ? this.bits.length : other.bits.length;
        for (int i = 0; i < len; ++i) {
            newbits[i] = this.bits[i] | other.bits[i];
        }
        if (diff > 0) {
            System.arraycopy(this.bits, len, newbits, len, diff);
        } else if (diff < 0) {
            System.arraycopy(other.bits, len, newbits, len, -diff);
        }
        return new BitSet(newsize, newbits);
    }

    public BitSet orNot(BitSet other) {
        int i;
        int diff = this.bits.length - other.bits.length;
        int newsize = Math.max(this.size, other.size);
        int lastsize = (newsize - 1) % 64 + 1;
        long lastmask = lastsize == 64 ? -1L : (1L << lastsize) - 1L;
        int len = diff <= 0 ? this.bits.length : other.bits.length;
        long[] newbits = BitSet.init(newsize);
        for (i = 0; i < len; ++i) {
            newbits[i] = this.bits[i] | other.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (diff > 0) {
            Arrays.fill(newbits, len, len + diff, -1L);
        } else if (diff < 0) {
            for (i = len; i < other.bits.length; ++i) {
                newbits[i] = other.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        int n = newbits.length - 1;
        newbits[n] = newbits[n] & lastmask;
        return new BitSet(newsize, newbits);
    }

    public BitSet xor(BitSet other) {
        int diff = this.bits.length - other.bits.length;
        int newsize = Math.max(this.size, other.size);
        int lastsize = (newsize - 1) % 64 + 1;
        long lastmask = lastsize == 64 ? -1L : (1L << lastsize) - 1L;
        int len = diff <= 0 ? this.bits.length : other.bits.length;
        long[] newbits = BitSet.init(newsize);
        for (int i = 0; i < len; ++i) {
            newbits[i] = this.bits[i] ^ other.bits[i];
        }
        int n = newbits.length - 1;
        newbits[n] = newbits[n] & lastmask;
        return new BitSet(newsize, newbits);
    }

    public BitSet eq(BitSet other) {
        int i;
        int diff = this.bits.length - other.bits.length;
        int newsize = Math.max(this.size, other.size);
        int lastsize = (newsize - 1) % 64 + 1;
        long lastmask = lastsize == 64 ? -1L : (1L << lastsize) - 1L;
        int len = diff <= 0 ? this.bits.length : other.bits.length;
        long[] newbits = BitSet.init(newsize);
        for (i = 0; i < len; ++i) {
            newbits[i] = this.bits[i] ^ other.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (diff > 0) {
            for (i = len; i < this.bits.length; ++i) {
                newbits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else if (diff < 0) {
            for (i = len; i < other.bits.length; ++i) {
                newbits[i] = other.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        int n = newbits.length - 1;
        newbits[n] = newbits[n] & lastmask;
        return new BitSet(newsize, newbits);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean get(int i) {
        if (i >= this.size) {
            return false;
        }
        int index = i / 64;
        int offset = i % 64;
        return (this.bits[index] & 1L << offset) != 0L;
    }

    public void set(int i) {
        if (i >= this.size) {
            return;
        }
        int index = i / 64;
        int offset = i % 64;
        int n = index;
        this.bits[n] = this.bits[n] | 1L << offset;
    }

    public void clear(int i) {
        if (i >= this.size) {
            return;
        }
        int index = i / 64;
        int offset = i % 64;
        int n = index;
        this.bits[n] = this.bits[n] & (1L << offset ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            if (i / 4 > 0 && i % 4 == 0) {
                buffer.insert(0, ' ');
            }
            if (this.get(i)) {
                buffer.insert(0, 1);
                continue;
            }
            buffer.insert(0, 0);
        }
        return buffer.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.bits) + this.size * 13;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitSet that = (BitSet)obj;
        return this.size == that.size && Arrays.equals(this.bits, that.bits);
    }

    public BitSet clone() {
        try {
            BitSet clone = (BitSet)super.clone();
            clone.bits = Arrays.copyOf(this.bits, this.bits.length);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static long[] init(int size) {
        return new long[(size - 1) / 64 + 1];
    }
}

