/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.tries;

import net.amygdalum.util.tries.CharTrieLeafNode;
import net.amygdalum.util.tries.CharTrieNode;
import net.amygdalum.util.tries.CharTrieTerminalNode;

public class CharTrieSingleNode<T>
extends CharTrieLeafNode<T>
implements CharTrieNode<T> {
    private char[] chars;
    private T[] attached;
    private TrieProxyNode<T>[] proxies;
    private char[] alt;

    public CharTrieSingleNode(char[] chars, T attached) {
        this(chars, CharTrieSingleNode.newAttached(attached, chars.length));
    }

    public CharTrieSingleNode(char c, CharTrieTerminalNode<T> next, T attached) {
        this(CharTrieSingleNode.newChars(c), CharTrieSingleNode.newAttached(attached, next.getAttached()));
    }

    public CharTrieSingleNode(char c, CharTrieSingleNode<T> next, T attached) {
        this(CharTrieSingleNode.newChars(c, next.chars), CharTrieSingleNode.newAttached(attached, next.attached));
    }

    public CharTrieSingleNode(char[] chars, T[] attached) {
        this.chars = chars;
        this.attached = attached;
        this.proxies = CharTrieSingleNode.proxies(chars.length);
        this.alt = new char[]{chars[0]};
    }

    private static char[] newChars(char next) {
        return new char[]{next};
    }

    private static char[] newChars(char next, char[] follow) {
        char[] chars = new char[follow.length + 1];
        chars[0] = next;
        System.arraycopy(follow, 0, chars, 1, follow.length);
        return chars;
    }

    private static <T> TrieProxyNode<T>[] proxies(int length) {
        return new TrieProxyNode[length];
    }

    private static <T> T[] newAttached(T next, T follow) {
        Object[] attached = new Object[]{next, follow};
        return attached;
    }

    private static <T> T[] newAttached(T next, T[] follow) {
        Object[] attached = new Object[follow.length + 1];
        attached[0] = next;
        System.arraycopy(follow, 0, attached, 1, follow.length);
        return attached;
    }

    private static <T> T[] newAttached(T last, int size) {
        Object[] attached = new Object[size + 1];
        attached[size] = last;
        return attached;
    }

    @Override
    public int length() {
        return this.chars.length;
    }

    @Override
    public CharTrieNode<T> nextNode(char c) {
        if (this.chars[0] != c) {
            return null;
        }
        return this.proxy(0);
    }

    @Override
    public CharTrieNode<T> nextNode(char[] chars) {
        int numberOfChars = chars.length;
        for (int i = 0; i < numberOfChars; ++i) {
            if (i >= this.chars.length) {
                return null;
            }
            if (this.chars[i] == chars[i]) continue;
            return null;
        }
        return this.proxy(numberOfChars - 1);
    }

    @Override
    public CharTrieNode<T> nextNode(char[] chars, int start) {
        int numberOfChars = chars.length - start;
        for (int i = 0; i < numberOfChars; ++i) {
            if (i >= this.chars.length) {
                return null;
            }
            if (this.chars[i] == chars[i + start]) continue;
            return null;
        }
        return this.proxy(numberOfChars - 1);
    }

    public CharTrieNode<T> proxy(int i) {
        if (this.proxies[i] == null) {
            this.proxies[i] = new TrieProxyNode(this, i);
        }
        return this.proxies[i];
    }

    @Override
    public T getAttached() {
        return this.attached[0];
    }

    @Override
    public char[] getAlternatives() {
        return this.alt;
    }

    private static class TrieProxyNode<T>
    extends CharTrieLeafNode<T>
    implements CharTrieNode<T> {
        private CharTrieSingleNode<T> base;
        private int offset;
        private char[] alt;

        public TrieProxyNode(CharTrieSingleNode<T> base, int offset) {
            char[] cArray;
            this.base = base;
            this.offset = offset + 1;
            if (this.offset == ((CharTrieSingleNode)base).chars.length) {
                cArray = new char[]{};
            } else {
                char[] cArray2 = new char[1];
                cArray = cArray2;
                cArray2[0] = ((CharTrieSingleNode)base).chars[this.offset];
            }
            this.alt = cArray;
        }

        @Override
        public int length() {
            return ((CharTrieSingleNode)this.base).chars.length - this.offset;
        }

        @Override
        public CharTrieNode<T> nextNode(char c) {
            if (((CharTrieSingleNode)this.base).chars.length <= this.offset) {
                return null;
            }
            if (((CharTrieSingleNode)this.base).chars[this.offset] != c) {
                return null;
            }
            return this.base.proxy(this.offset);
        }

        @Override
        public CharTrieNode<T> nextNode(char[] chars) {
            int numberOfChars = chars.length;
            for (int i = 0; i < numberOfChars; ++i) {
                int offi = this.offset + i;
                if (offi >= ((CharTrieSingleNode)this.base).chars.length) {
                    return null;
                }
                if (((CharTrieSingleNode)this.base).chars[offi] == chars[i]) continue;
                return null;
            }
            return this.base.proxy(this.offset + numberOfChars - 1);
        }

        @Override
        public CharTrieNode<T> nextNode(char[] chars, int start) {
            int numberOfChars = chars.length - start;
            for (int i = 0; i < numberOfChars; ++i) {
                int offi = this.offset + i;
                if (offi >= ((CharTrieSingleNode)this.base).chars.length) {
                    return null;
                }
                if (((CharTrieSingleNode)this.base).chars[offi] == chars[i + start]) continue;
                return null;
            }
            return this.base.proxy(this.offset + numberOfChars - 1);
        }

        @Override
        public T getAttached() {
            return (T)((CharTrieSingleNode)this.base).attached[this.offset];
        }

        @Override
        public char[] getAlternatives() {
            return this.alt;
        }
    }
}

