/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.tries;

import java.util.HashMap;
import java.util.Map;
import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.tries.CharTrieArrayNode;
import net.amygdalum.util.tries.CharTrieLeafNode;
import net.amygdalum.util.tries.CharTrieMapNode;
import net.amygdalum.util.tries.CharTrieNode;
import net.amygdalum.util.tries.CharTrieSingleNode;
import net.amygdalum.util.tries.CharTrieTerminalNode;
import net.amygdalum.util.tries.PreCharTrieNode;

public class CharTrieNodeCompiler<T> {
    private boolean compressed;
    private Map<PreCharTrieNode<T>, CharTrieNode<T>> nodes;
    private Map<CharTrieNode<T>, PreCharTrieNode<T>> reverse;

    public CharTrieNodeCompiler(boolean compressed) {
        this.compressed = compressed;
        this.nodes = new HashMap<PreCharTrieNode<T>, CharTrieNode<T>>();
        this.reverse = new HashMap<CharTrieNode<T>, PreCharTrieNode<T>>();
    }

    public CharTrieNode<T>[] compileAndLink(PreCharTrieNode<T>[] node) {
        CharTrieNode[] compiled = new CharTrieNode[node.length];
        for (int i = 0; i < compiled.length; ++i) {
            compiled[i] = this.compile(node[i]);
        }
        this.link();
        return compiled;
    }

    public CharTrieNode<T> compileAndLink(PreCharTrieNode<T> node) {
        CharTrieNode<T> compiled = this.compile(node);
        this.link();
        return compiled;
    }

    private CharTrieNode<T> compile(PreCharTrieNode<T> node) {
        if (node == null) {
            return null;
        }
        CharTrieNode<T> compiled = this.nodes.get(node);
        if (compiled == null) {
            T attached;
            CharObjectMap<CharTrieNode<T>> nexts = this.compile(node.getNexts());
            compiled = this.createNode(nexts, attached = node.getAttached());
            if (compiled instanceof CharTrieLeafNode) {
                this.reverse.put(compiled, node);
            }
            this.nodes.put(node, compiled);
        }
        return compiled;
    }

    private void link() {
        for (Map.Entry<PreCharTrieNode<T>, CharTrieNode<T>> entry : this.nodes.entrySet()) {
            PreCharTrieNode<T> key = entry.getKey();
            PreCharTrieNode<T> link = key.getLink();
            if (link == null) continue;
            CharTrieNode<T> value = this.resolve(entry.getValue());
            CharTrieNode<T> target = this.resolve(this.nodes.get(link));
            value.link(target);
        }
    }

    private CharTrieNode<T> resolve(CharTrieNode<T> node) {
        if (node instanceof TemporaryCharTrieNode) {
            return ((TemporaryCharTrieNode)node).resolve();
        }
        return node;
    }

    private CharObjectMap<CharTrieNode<T>> compile(CharObjectMap<PreCharTrieNode<T>> nexts) {
        CharTrieNode<T> defaultValue = this.compile(nexts.getDefaultValue());
        CharObjectMap<CharTrieNode<CharTrieNode<T>>> compiled = new CharObjectMap<CharTrieNode<CharTrieNode<T>>>(defaultValue);
        for (CharObjectMap.Entry<PreCharTrieNode<T>> entry : nexts.cursor()) {
            char key = entry.key;
            PreCharTrieNode value = (PreCharTrieNode)entry.value;
            compiled.put(key, this.compile(value));
        }
        return compiled;
    }

    private CharTrieNode<T> createNode(CharObjectMap<CharTrieNode<T>> nexts, T attached) {
        if (this.isQualifiedForLeafNode(nexts)) {
            return this.createTrieLeafNode(nexts, attached);
        }
        if (this.isQualifiedForSingleNode(nexts)) {
            return this.createTrieSingleNode(nexts, attached);
        }
        if (this.isQualifiedForArrayNode(nexts)) {
            return this.createTrieArrayNode(nexts, attached);
        }
        return this.createTrieMapNode(nexts, attached);
    }

    private boolean isQualifiedForLeafNode(CharObjectMap<CharTrieNode<T>> nexts) {
        return nexts.size() == 0;
    }

    private CharTrieNode<T> createTrieLeafNode(CharObjectMap<CharTrieNode<T>> nexts, T attached) {
        return new CharTrieTerminalNode<T>(attached);
    }

    private boolean isQualifiedForSingleNode(CharObjectMap<CharTrieNode<T>> nexts) {
        if (this.compressed && nexts.size() == 1) {
            CharTrieNode next = (CharTrieNode)nexts.cursor().iterator().next().value;
            return next instanceof CharTrieSingleNode || next instanceof CharTrieTerminalNode;
        }
        return false;
    }

    private CharTrieNode<T> createTrieSingleNode(CharObjectMap<CharTrieNode<T>> nexts, T attached) {
        CharObjectMap.Entry<CharTrieNode<T>> next = nexts.cursor().iterator().next();
        char key = next.key;
        CharTrieNode value = (CharTrieNode)next.value;
        CharTrieSingleNode<T> newNode = this.subsume(key, value, attached);
        PreCharTrieNode<T> toRemap = this.reverse.get(value);
        TemporaryCharTrieNode<T> target = new TemporaryCharTrieNode<T>(newNode, 0);
        this.nodes.put(toRemap, target);
        for (PreCharTrieNode<T> node : toRemap.nodes()) {
            CharTrieNode<T> followNode;
            if (node == toRemap || !((followNode = this.nodes.get(node)) instanceof TemporaryCharTrieNode)) continue;
            ((TemporaryCharTrieNode)followNode).shift(newNode);
        }
        return newNode;
    }

    public CharTrieSingleNode<T> subsume(char key, CharTrieNode<T> value, T attached) {
        if (value instanceof CharTrieSingleNode) {
            return new CharTrieSingleNode<T>(key, (CharTrieSingleNode)value, attached);
        }
        if (value instanceof CharTrieTerminalNode) {
            return new CharTrieSingleNode<T>(key, (CharTrieTerminalNode)value, attached);
        }
        throw new UnsupportedOperationException();
    }

    private boolean isQualifiedForArrayNode(CharObjectMap<CharTrieNode<T>> nexts) {
        return CharTrieArrayNode.computeArraySize(nexts) != -1;
    }

    private CharTrieNode<T> createTrieArrayNode(CharObjectMap<CharTrieNode<T>> nexts, T attached) {
        return new CharTrieArrayNode<T>(nexts, attached);
    }

    private CharTrieNode<T> createTrieMapNode(CharObjectMap<CharTrieNode<T>> nexts, T attached) {
        return new CharTrieMapNode<T>(nexts, attached);
    }

    private static class TemporaryCharTrieNode<T>
    implements CharTrieNode<T> {
        private CharTrieSingleNode<T> node;
        private int pos;

        public TemporaryCharTrieNode(CharTrieSingleNode<T> node, int pos) {
            this.node = node;
            this.pos = pos;
        }

        public void shift(CharTrieSingleNode<T> node) {
            this.node = node;
            ++this.pos;
        }

        public CharTrieNode<T> resolve() {
            return this.node.proxy(this.pos);
        }

        @Override
        public CharTrieNode<T> nextNode(char c) {
            return this.resolve().nextNode(c);
        }

        @Override
        public CharTrieNode<T> nextNode(char[] chars) {
            return this.resolve().nextNode(chars);
        }

        @Override
        public CharTrieNode<T> nextNode(char[] chars, int start) {
            return this.resolve().nextNode(chars, start);
        }

        @Override
        public T getAttached() {
            return this.resolve().getAttached();
        }

        @Override
        public char[] getAlternatives() {
            return this.resolve().getAlternatives();
        }

        @Override
        public void link(CharTrieNode<T> node) {
            this.resolve().link(node);
        }

        @Override
        public CharTrieNode<T> getLink() {
            return this.resolve().getLink();
        }
    }
}

