/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.tries;

import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.tries.CharTrieInnerNode;
import net.amygdalum.util.tries.CharTrieNode;

public class CharTrieArrayNode<T>
extends CharTrieInnerNode<T>
implements CharTrieNode<T> {
    private int size;
    private int mask;
    private char[] chars;
    private CharTrieNode<T>[] nodes;
    private char[] alts;

    public CharTrieArrayNode(CharObjectMap<CharTrieNode<T>> nexts, T attached) {
        super(attached);
        this.size = CharTrieArrayNode.computeArraySize(nexts);
        this.mask = this.size - 1;
        this.chars = CharTrieArrayNode.chars(nexts, this.size, this.mask);
        this.nodes = CharTrieArrayNode.nodes(nexts, this.size, this.mask);
        this.alts = CharTrieArrayNode.alts(nexts);
    }

    public static <T> int computeArraySize(CharObjectMap<CharTrieNode<T>> nexts) {
        int nextSize = nexts.size();
        for (int minimumSize = 1; minimumSize < nextSize; minimumSize <<= 1) {
        }
        block1: for (int size = minimumSize; size < 256; size <<= 1) {
            boolean[] collision = new boolean[size];
            int mask = size - 1;
            for (CharObjectMap.Entry<CharTrieNode<T>> entry : nexts.cursor()) {
                int index = entry.key & mask;
                if (collision[index]) continue block1;
                collision[index] = true;
            }
            return size;
        }
        return -1;
    }

    private static <T> char[] chars(CharObjectMap<CharTrieNode<T>> nexts, int size, int mask) {
        char[] chars = new char[size];
        for (CharObjectMap.Entry<CharTrieNode<T>> entry : nexts.cursor()) {
            int index = entry.key & mask;
            chars[index] = entry.key;
        }
        return chars;
    }

    private static <T> CharTrieNode<T>[] nodes(CharObjectMap<CharTrieNode<T>> nexts, int size, int mask) {
        CharTrieNode[] nodes = new CharTrieNode[size];
        for (CharObjectMap.Entry<CharTrieNode<T>> entry : nexts.cursor()) {
            int index = entry.key & mask;
            nodes[index] = (CharTrieNode)entry.value;
        }
        return nodes;
    }

    private static <T> char[] alts(CharObjectMap<CharTrieNode<T>> nexts) {
        char[] chars = new char[nexts.size()];
        int i = 0;
        for (CharObjectMap.Entry<CharTrieNode<T>> entry : nexts.cursor()) {
            chars[i] = entry.key;
            ++i;
        }
        return chars;
    }

    @Override
    public CharTrieNode<T> nextNode(char c) {
        if (this.nodes.length == 0) {
            return null;
        }
        int index = c & this.mask;
        if (this.chars[index] != c) {
            return null;
        }
        return this.nodes[index];
    }

    @Override
    public char[] getAlternatives() {
        return this.alts;
    }
}

