/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.tries;

import net.amygdalum.util.tries.ByteTrieLeafNode;
import net.amygdalum.util.tries.ByteTrieNode;
import net.amygdalum.util.tries.ByteTrieTerminalNode;

public class ByteTrieSingleNode<T>
extends ByteTrieLeafNode<T>
implements ByteTrieNode<T> {
    private byte[] bytes;
    private T[] attached;
    private TrieProxyNode<T>[] proxies;
    private byte[] alt;

    public ByteTrieSingleNode(byte[] bytes, T attached) {
        this(bytes, ByteTrieSingleNode.newAttached(attached, bytes.length));
    }

    public ByteTrieSingleNode(byte b, ByteTrieTerminalNode<T> next, T attached) {
        this(ByteTrieSingleNode.newBytes(b), ByteTrieSingleNode.newAttached(attached, next.getAttached()));
    }

    public ByteTrieSingleNode(byte b, ByteTrieSingleNode<T> next, T attached) {
        this(ByteTrieSingleNode.newBytes(b, next.bytes), ByteTrieSingleNode.newAttached(attached, next.attached));
    }

    public ByteTrieSingleNode(byte[] bytes, T[] attached) {
        this.bytes = bytes;
        this.attached = attached;
        this.proxies = ByteTrieSingleNode.proxies(bytes.length);
        this.alt = new byte[]{bytes[0]};
    }

    private static byte[] newBytes(byte next) {
        return new byte[]{next};
    }

    private static byte[] newBytes(byte next, byte[] follow) {
        byte[] bytes = new byte[follow.length + 1];
        bytes[0] = next;
        System.arraycopy(follow, 0, bytes, 1, follow.length);
        return bytes;
    }

    private static <T> TrieProxyNode<T>[] proxies(int length) {
        return new TrieProxyNode[length];
    }

    private static <T> T[] newAttached(T next, T follow) {
        Object[] attached = new Object[]{next, follow};
        return attached;
    }

    private static <T> T[] newAttached(T next, T[] follow) {
        Object[] attached = new Object[follow.length + 1];
        attached[0] = next;
        System.arraycopy(follow, 0, attached, 1, follow.length);
        return attached;
    }

    private static <T> T[] newAttached(T last, int size) {
        Object[] attached = new Object[size + 1];
        attached[size] = last;
        return attached;
    }

    @Override
    public int length() {
        return this.bytes.length;
    }

    @Override
    public ByteTrieNode<T> nextNode(byte b) {
        if (this.bytes[0] != b) {
            return null;
        }
        return this.proxy(0);
    }

    @Override
    public ByteTrieNode<T> nextNode(byte[] bytes) {
        int numberOfChars = bytes.length;
        for (int i = 0; i < numberOfChars; ++i) {
            if (i >= this.bytes.length) {
                return null;
            }
            if (this.bytes[i] == bytes[i]) continue;
            return null;
        }
        return this.proxy(numberOfChars - 1);
    }

    @Override
    public ByteTrieNode<T> nextNode(byte[] bytes, int start) {
        int numberOfBytes = bytes.length - start;
        for (int i = 0; i < numberOfBytes; ++i) {
            if (i >= this.bytes.length) {
                return null;
            }
            if (this.bytes[i] == bytes[i + start]) continue;
            return null;
        }
        return this.proxy(numberOfBytes - 1);
    }

    public ByteTrieNode<T> proxy(int i) {
        if (this.proxies[i] == null) {
            this.proxies[i] = new TrieProxyNode(this, i);
        }
        return this.proxies[i];
    }

    @Override
    public T getAttached() {
        return this.attached[0];
    }

    @Override
    public byte[] getAlternatives() {
        return this.alt;
    }

    private static class TrieProxyNode<T>
    extends ByteTrieLeafNode<T>
    implements ByteTrieNode<T> {
        private ByteTrieSingleNode<T> base;
        private int offset;
        private byte[] alt;

        public TrieProxyNode(ByteTrieSingleNode<T> base, int offset) {
            byte[] byArray;
            this.base = base;
            this.offset = offset + 1;
            if (this.offset == ((ByteTrieSingleNode)base).bytes.length) {
                byArray = new byte[]{};
            } else {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = ((ByteTrieSingleNode)base).bytes[this.offset];
            }
            this.alt = byArray;
        }

        @Override
        public int length() {
            return ((ByteTrieSingleNode)this.base).bytes.length - this.offset;
        }

        @Override
        public ByteTrieNode<T> nextNode(byte b) {
            if (((ByteTrieSingleNode)this.base).bytes.length <= this.offset) {
                return null;
            }
            if (((ByteTrieSingleNode)this.base).bytes[this.offset] != b) {
                return null;
            }
            return this.base.proxy(this.offset);
        }

        @Override
        public ByteTrieNode<T> nextNode(byte[] bytes) {
            int numberOfChars = bytes.length;
            for (int i = 0; i < numberOfChars; ++i) {
                int offi = this.offset + i;
                if (offi >= ((ByteTrieSingleNode)this.base).bytes.length) {
                    return null;
                }
                if (((ByteTrieSingleNode)this.base).bytes[offi] == bytes[i]) continue;
                return null;
            }
            return this.base.proxy(this.offset + numberOfChars - 1);
        }

        @Override
        public ByteTrieNode<T> nextNode(byte[] bytes, int start) {
            int numberOfChars = bytes.length - start;
            for (int i = 0; i < numberOfChars; ++i) {
                int offi = this.offset + i;
                if (offi >= ((ByteTrieSingleNode)this.base).bytes.length) {
                    return null;
                }
                if (((ByteTrieSingleNode)this.base).bytes[offi] == bytes[i + start]) continue;
                return null;
            }
            return this.base.proxy(this.offset + numberOfChars - 1);
        }

        @Override
        public T getAttached() {
            return (T)((ByteTrieSingleNode)this.base).attached[this.offset];
        }

        @Override
        public byte[] getAlternatives() {
            return this.alt;
        }
    }
}

