/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.tries;

import java.util.HashMap;
import java.util.Map;
import net.amygdalum.util.map.ByteObjectMap;
import net.amygdalum.util.tries.ByteTrieArrayNode;
import net.amygdalum.util.tries.ByteTrieLeafNode;
import net.amygdalum.util.tries.ByteTrieNode;
import net.amygdalum.util.tries.ByteTrieSingleNode;
import net.amygdalum.util.tries.ByteTrieTerminalNode;
import net.amygdalum.util.tries.PreByteTrieNode;

public class ByteTrieNodeCompiler<T> {
    private boolean compressed;
    private Map<PreByteTrieNode<T>, ByteTrieNode<T>> nodes;
    private Map<ByteTrieNode<T>, PreByteTrieNode<T>> reverse;

    public ByteTrieNodeCompiler(boolean compressed) {
        this.compressed = compressed;
        this.nodes = new HashMap<PreByteTrieNode<T>, ByteTrieNode<T>>();
        this.reverse = new HashMap<ByteTrieNode<T>, PreByteTrieNode<T>>();
    }

    public ByteTrieNode<T>[] compileAndLink(PreByteTrieNode<T>[] node) {
        ByteTrieNode[] compiled = new ByteTrieNode[node.length];
        for (int i = 0; i < compiled.length; ++i) {
            compiled[i] = this.compile(node[i]);
        }
        this.link();
        return compiled;
    }

    public ByteTrieNode<T> compileAndLink(PreByteTrieNode<T> node) {
        ByteTrieNode<T> compiled = this.compile(node);
        this.link();
        return compiled;
    }

    private ByteTrieNode<T> compile(PreByteTrieNode<T> node) {
        if (node == null) {
            return null;
        }
        ByteTrieNode<T> compiled = this.nodes.get(node);
        if (compiled == null) {
            T attached;
            ByteObjectMap<ByteTrieNode<T>> nexts = this.compile(node.getNexts());
            compiled = this.createNode(nexts, attached = node.getAttached());
            if (compiled instanceof ByteTrieLeafNode) {
                this.reverse.put(compiled, node);
            }
            this.nodes.put(node, compiled);
        }
        return compiled;
    }

    private void link() {
        for (Map.Entry<PreByteTrieNode<T>, ByteTrieNode<T>> entry : this.nodes.entrySet()) {
            PreByteTrieNode<T> key = entry.getKey();
            PreByteTrieNode<T> link = key.getLink();
            if (link == null) continue;
            ByteTrieNode<T> value = this.resolve(entry.getValue());
            ByteTrieNode<T> target = this.resolve(this.nodes.get(link));
            value.link(target);
        }
    }

    private ByteTrieNode<T> resolve(ByteTrieNode<T> node) {
        if (node instanceof TemporaryByteTrieNode) {
            return ((TemporaryByteTrieNode)node).resolve();
        }
        return node;
    }

    private ByteObjectMap<ByteTrieNode<T>> compile(ByteObjectMap<PreByteTrieNode<T>> nexts) {
        ByteTrieNode<T> defaultValue = this.compile(nexts.getDefaultValue());
        ByteObjectMap<ByteTrieNode<ByteTrieNode<T>>> compiled = new ByteObjectMap<ByteTrieNode<ByteTrieNode<T>>>(defaultValue);
        for (ByteObjectMap.Entry<PreByteTrieNode<T>> entry : nexts.cursor()) {
            byte key = entry.key;
            PreByteTrieNode value = (PreByteTrieNode)entry.value;
            compiled.put(key, this.compile(value));
        }
        return compiled;
    }

    private ByteTrieNode<T> createNode(ByteObjectMap<ByteTrieNode<T>> nexts, T attached) {
        if (this.isQualifiedForLeafNode(nexts)) {
            return this.createTrieLeafNode(nexts, attached);
        }
        if (this.isQualifiedForSingleNode(nexts)) {
            return this.createTrieSingleNode(nexts, attached);
        }
        return this.createTrieArrayNode(nexts, attached);
    }

    private boolean isQualifiedForLeafNode(ByteObjectMap<ByteTrieNode<T>> nexts) {
        return nexts.size() == 0;
    }

    private ByteTrieNode<T> createTrieLeafNode(ByteObjectMap<ByteTrieNode<T>> nexts, T attached) {
        return new ByteTrieTerminalNode<T>(attached);
    }

    private boolean isQualifiedForSingleNode(ByteObjectMap<ByteTrieNode<T>> nexts) {
        if (this.compressed && nexts.size() == 1) {
            ByteTrieNode next = (ByteTrieNode)nexts.cursor().iterator().next().value;
            return next instanceof ByteTrieSingleNode || next instanceof ByteTrieTerminalNode;
        }
        return false;
    }

    private ByteTrieNode<T> createTrieSingleNode(ByteObjectMap<ByteTrieNode<T>> nexts, T attached) {
        ByteObjectMap.Entry<ByteTrieNode<T>> next = nexts.cursor().iterator().next();
        byte key = next.key;
        ByteTrieNode value = (ByteTrieNode)next.value;
        ByteTrieSingleNode<T> newNode = this.subsume(key, value, attached);
        PreByteTrieNode<T> toRemap = this.reverse.get(value);
        TemporaryByteTrieNode<T> target = new TemporaryByteTrieNode<T>(newNode, 0);
        this.nodes.put(toRemap, target);
        for (PreByteTrieNode<T> node : toRemap.nodes()) {
            ByteTrieNode<T> followNode;
            if (node == toRemap || !((followNode = this.nodes.get(node)) instanceof TemporaryByteTrieNode)) continue;
            ((TemporaryByteTrieNode)followNode).shift(newNode);
        }
        return newNode;
    }

    public ByteTrieSingleNode<T> subsume(byte key, ByteTrieNode<T> value, T attached) {
        if (value instanceof ByteTrieSingleNode) {
            return new ByteTrieSingleNode<T>(key, (ByteTrieSingleNode)value, attached);
        }
        if (value instanceof ByteTrieTerminalNode) {
            return new ByteTrieSingleNode<T>(key, (ByteTrieTerminalNode)value, attached);
        }
        throw new UnsupportedOperationException();
    }

    private ByteTrieNode<T> createTrieArrayNode(ByteObjectMap<ByteTrieNode<T>> nexts, T attached) {
        return new ByteTrieArrayNode<T>(nexts, attached);
    }

    private static class TemporaryByteTrieNode<T>
    implements ByteTrieNode<T> {
        private ByteTrieSingleNode<T> node;
        private int pos;

        public TemporaryByteTrieNode(ByteTrieSingleNode<T> node, int pos) {
            this.node = node;
            this.pos = pos;
        }

        public void shift(ByteTrieSingleNode<T> node) {
            this.node = node;
            ++this.pos;
        }

        public ByteTrieNode<T> resolve() {
            return this.node.proxy(this.pos);
        }

        @Override
        public ByteTrieNode<T> nextNode(byte b) {
            return this.resolve().nextNode(b);
        }

        @Override
        public ByteTrieNode<T> nextNode(byte[] bytes) {
            return this.resolve().nextNode(bytes);
        }

        @Override
        public ByteTrieNode<T> nextNode(byte[] bytes, int start) {
            return this.resolve().nextNode(bytes, start);
        }

        @Override
        public T getAttached() {
            return this.resolve().getAttached();
        }

        @Override
        public byte[] getAlternatives() {
            return this.resolve().getAlternatives();
        }

        @Override
        public void link(ByteTrieNode<T> node) {
            this.resolve().link(node);
        }

        @Override
        public ByteTrieNode<T> getLink() {
            return this.resolve().getLink();
        }
    }
}

