/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.tries;

import net.amygdalum.util.map.ByteObjectMap;
import net.amygdalum.util.tries.ByteTrieInnerNode;
import net.amygdalum.util.tries.ByteTrieNode;

public class ByteTrieArrayNode<T>
extends ByteTrieInnerNode<T>
implements ByteTrieNode<T> {
    private int size;
    private int mask;
    private byte[] bytes;
    private ByteTrieNode<T>[] nodes;
    private byte[] alts;

    public ByteTrieArrayNode(ByteObjectMap<ByteTrieNode<T>> nexts, T attached) {
        super(attached);
        this.size = ByteTrieArrayNode.computeArraySize(nexts);
        this.mask = this.size - 1;
        this.bytes = ByteTrieArrayNode.bytes(nexts, this.size, this.mask);
        this.nodes = ByteTrieArrayNode.nodes(nexts, this.size, this.mask);
        this.alts = ByteTrieArrayNode.alts(nexts);
    }

    public static <T> int computeArraySize(ByteObjectMap<ByteTrieNode<T>> nexts) {
        int nextSize = nexts.size();
        for (int minimumSize = 1; minimumSize < nextSize; minimumSize <<= 1) {
        }
        block1: for (int size = minimumSize; size < 256; size <<= 1) {
            boolean[] collision = new boolean[size];
            int mask = size - 1;
            for (ByteObjectMap.Entry<ByteTrieNode<T>> entry : nexts.cursor()) {
                int index = entry.key & mask;
                if (collision[index]) continue block1;
                collision[index] = true;
            }
            return size;
        }
        return 256;
    }

    private static <T> byte[] bytes(ByteObjectMap<ByteTrieNode<T>> nexts, int size, int mask) {
        byte[] chars = new byte[size];
        for (ByteObjectMap.Entry<ByteTrieNode<T>> entry : nexts.cursor()) {
            int index = entry.key & mask;
            chars[index] = entry.key;
        }
        return chars;
    }

    private static <T> ByteTrieNode<T>[] nodes(ByteObjectMap<ByteTrieNode<T>> nexts, int size, int mask) {
        ByteTrieNode[] nodes = new ByteTrieNode[size];
        for (ByteObjectMap.Entry<ByteTrieNode<T>> entry : nexts.cursor()) {
            int index = entry.key & mask;
            nodes[index] = (ByteTrieNode)entry.value;
        }
        return nodes;
    }

    private static <T> byte[] alts(ByteObjectMap<ByteTrieNode<T>> nexts) {
        byte[] bytes = new byte[nexts.size()];
        int i = 0;
        for (ByteObjectMap.Entry<ByteTrieNode<T>> entry : nexts.cursor()) {
            bytes[i] = entry.key;
            ++i;
        }
        return bytes;
    }

    @Override
    public ByteTrieNode<T> nextNode(byte b) {
        if (this.nodes.length == 0) {
            return null;
        }
        int index = b & this.mask;
        if (this.bytes[index] != b) {
            return null;
        }
        return this.nodes[index];
    }

    @Override
    public byte[] getAlternatives() {
        return this.alts;
    }
}

