/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.text;

import java.util.List;
import net.amygdalum.util.text.QGramMapping;

public class QGramAlphabet {
    private QGramMapping mapping;
    private int minQGram;
    private int maxQGram;

    private QGramAlphabet(QGramMapping mapping) {
        this.mapping = mapping;
        this.minQGram = Integer.MAX_VALUE;
        this.maxQGram = 0;
    }

    public static QGramAlphabet of(List<char[]> patterns, QGramMapping mapping) {
        QGramAlphabet qgramAlphabet = new QGramAlphabet(mapping);
        for (char[] pattern : patterns) {
            for (int qc : mapping.iterate(pattern)) {
                qgramAlphabet.add(qc);
            }
        }
        return qgramAlphabet;
    }

    public QGramMapping getMapping() {
        return this.mapping;
    }

    public void add(int qc) {
        if (qc < this.minQGram) {
            this.minQGram = qc;
        }
        if (qc > this.maxQGram) {
            this.maxQGram = qc;
        }
    }

    public int minQGram() {
        return this.minQGram;
    }

    public int maxQGram() {
        return this.maxQGram;
    }
}

