/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.text;

import java.util.List;

public final class ByteUtils {
    public static final int BYTE_RANGE = 256;

    private ByteUtils() {
    }

    public static byte after(byte b) {
        return (byte)(b + 1);
    }

    public static byte before(byte b) {
        return (byte)(b - 1);
    }

    public static byte[] revert(byte[] bytes) {
        int ri = bytes.length - 1;
        byte[] reversebytes = new byte[bytes.length];
        for (int i = 0; i < reversebytes.length; ++i) {
            reversebytes[i] = bytes[ri - i];
        }
        return reversebytes;
    }

    public static int lastIndexOf(byte[] pattern, byte[] block) {
        block0: for (int i = pattern.length - block.length; i >= 0; --i) {
            for (int j = block.length - 1; j >= 0; --j) {
                if (pattern[j + i] != block[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int minLength(List<byte[]> patterns) {
        int len = Integer.MAX_VALUE;
        for (byte[] pattern : patterns) {
            if (pattern.length >= len) continue;
            len = pattern.length;
        }
        return len;
    }

    public static int maxLength(List<byte[]> patterns) {
        int len = Integer.MIN_VALUE;
        for (byte[] pattern : patterns) {
            if (pattern.length <= len) continue;
            len = pattern.length;
        }
        return len;
    }
}

