/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.map;

import net.amygdalum.util.map.TuneableMap;

public class CharLongMap
extends TuneableMap {
    private static final char NULL_KEY = '\u0000';
    private float loadFactor;
    private int mask;
    private int expandAt;
    private int size;
    private char[] keys;
    private long[] values;
    private long defaultValue;
    private long nullValue;

    public CharLongMap(long defaultValue) {
        this(16, 0.7f, defaultValue);
    }

    public CharLongMap(int initialSize, float loadFactor, long defaultValue) {
        this.loadFactor = loadFactor;
        this.mask = CharLongMap.mask(initialSize, loadFactor);
        this.expandAt = initialSize;
        this.size = 0;
        this.keys = new char[this.mask + 1];
        this.values = new long[this.mask + 1];
        this.defaultValue = defaultValue;
        this.nullValue = defaultValue;
    }

    public char[] keys() {
        int size = this.size;
        if (this.nullValue != this.defaultValue) {
            ++size;
        }
        char[] keys = new char[size];
        int pos = 0;
        for (char c : this.keys) {
            if (c == '\u0000') continue;
            keys[pos] = c;
            ++pos;
        }
        if (this.nullValue != this.defaultValue && pos < keys.length) {
            keys[pos] = '\u0000';
        }
        return keys;
    }

    public CharLongMap add(char key, long value) {
        this.put(key, value);
        return this;
    }

    public void put(char key, long value) {
        if (key == '\u0000') {
            this.nullValue = value;
            return;
        }
        int slot = CharLongMap.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != '\u0000') {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == '\u0000') {
            ++this.size;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        if (this.size > this.expandAt) {
            this.expand(this.size * 2);
        }
    }

    public long get(char key) {
        if (key == '\u0000') {
            return this.nullValue;
        }
        int slot = CharLongMap.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != '\u0000') {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == '\u0000') {
            return this.defaultValue;
        }
        return this.values[slot];
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    private void expand(int size) {
        int i;
        int mask = CharLongMap.mask(size, this.loadFactor);
        char[] oldkeys = this.keys;
        long[] oldvalues = this.values;
        char[] keys = new char[mask + 1];
        long[] values = new long[mask + 1];
        int[] delayed = new int[this.size];
        int pos = 0;
        for (i = 0; i < oldkeys.length; ++i) {
            char key = oldkeys[i];
            if (key == '\u0000') continue;
            long value = oldvalues[i];
            int slot = CharLongMap.hash(key) & mask;
            if (keys[slot] == '\u0000') {
                keys[slot] = key;
                values[slot] = value;
                continue;
            }
            delayed[pos] = i;
            ++pos;
        }
        for (i = 0; i <= pos; ++i) {
            int j = delayed[i];
            char key = oldkeys[j];
            long value = oldvalues[j];
            int slot = CharLongMap.hash(key) & mask;
            while (keys[slot] != key && keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
        this.expandAt = size;
        this.mask = mask;
        this.keys = keys;
        this.values = values;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        if (this.keys.length > 0) {
            char key = this.keys[0];
            long value = this.values[0];
            buffer.append(key).append(": ").append(value);
        }
        for (int i = 1; i < this.keys.length; ++i) {
            char key = this.keys[i];
            long value = this.values[0];
            buffer.append(",\n").append(key).append(": ").append(value);
        }
        buffer.append("\n}");
        return buffer.toString();
    }
}

