/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.io.IORuntimeException;
import net.amygdalum.util.io.OutOfBufferException;
import net.amygdalum.util.text.ByteString;

public class StreamByteProvider
implements ByteProvider {
    private static final long NO_MARK = Long.MIN_VALUE;
    private InputStream input;
    private Charset charset;
    private int bufferSize;
    private int bufferNumber;
    private byte[][] buffers;
    private int currentIndex;
    private int currentPos;
    private int topIndex;
    private int topPos;
    private long absolutePos;
    private long mark;

    public StreamByteProvider(InputStream input, long start, int chunk, int lookaroundBuffers) {
        this(input, StandardCharsets.UTF_16LE, start, chunk, lookaroundBuffers);
    }

    public StreamByteProvider(InputStream input, Charset charset, long start, int chunk, int lookaroundBuffers) {
        this.input = input;
        this.charset = charset;
        this.bufferSize = chunk;
        this.bufferNumber = lookaroundBuffers + 1;
        this.buffers = new byte[this.bufferNumber][this.bufferSize];
        this.currentIndex = -1;
        this.currentPos = 0;
        this.topIndex = -1;
        this.topPos = 0;
        this.mark = Long.MIN_VALUE;
        this.init(start);
    }

    public final void init(long start) {
        int buffersToRead = (int)(start / (long)this.bufferSize) + 1;
        this.read(buffersToRead);
        this.currentIndex = this.topIndex;
        this.currentPos = (int)(start % (long)this.bufferSize);
        this.absolutePos = start;
    }

    private int read(int buffersToRead) {
        if (buffersToRead <= 0) {
            return 0;
        }
        try {
            int freeBuffers;
            int buffersToShift;
            int buffersAlreadyRead = this.topIndex - this.currentIndex;
            for (int i = 0; i < buffersAlreadyRead; ++i) {
                --buffersToRead;
            }
            int buffersToSkip = buffersToRead - this.bufferNumber;
            if (buffersToSkip > 0) {
                for (int i = 0; i < buffersToSkip; ++i) {
                    this.topPos = this.input.read(this.buffers[0]);
                    --buffersToRead;
                }
                this.topIndex = -1;
                this.currentIndex = -1;
            }
            if ((buffersToShift = buffersToRead - (freeBuffers = this.bufferNumber - this.currentIndex - 1)) > 0) {
                int lastIndexToReplace = this.bufferNumber - buffersToShift;
                for (int i = 0; i < lastIndexToReplace; ++i) {
                    byte[] temp = this.buffers[i];
                    this.buffers[i] = this.buffers[i + buffersToShift];
                    this.buffers[i + buffersToShift] = temp;
                }
                this.topIndex -= buffersToShift;
            }
            while (buffersToRead > 0) {
                ++this.topIndex;
                this.topPos = this.input.read(this.buffers[this.topIndex]);
                --buffersToRead;
                if (this.topPos >= this.bufferSize) continue;
            }
            if (buffersToRead > 0) {
                throw new OutOfBufferException();
            }
            if (buffersToSkip > 0) {
                return buffersToSkip + this.bufferNumber;
            }
            if (buffersToShift > 0) {
                return buffersToShift;
            }
            return 0;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private int readAhead(int buffersToRead) {
        if (buffersToRead <= 0) {
            return 0;
        }
        try {
            int freeBuffers = this.bufferNumber - this.topIndex - 1;
            int buffersToShift = buffersToRead - freeBuffers;
            if (buffersToShift > this.currentIndex) {
                throw new OutOfBufferException();
            }
            if (buffersToShift > 0) {
                int lastIndexToReplace = this.bufferNumber - buffersToShift;
                for (int i = 0; i < lastIndexToReplace; ++i) {
                    byte[] temp = this.buffers[i];
                    this.buffers[i] = this.buffers[i + buffersToShift];
                    this.buffers[i + buffersToShift] = temp;
                }
                this.currentIndex -= buffersToShift;
                this.topIndex -= buffersToShift;
            }
            while (buffersToRead > 0) {
                ++this.topIndex;
                this.topPos = this.input.read(this.buffers[this.topIndex]);
                --buffersToRead;
                if (this.topPos >= this.bufferSize) continue;
            }
            if (buffersToRead > 0) {
                throw new OutOfBufferException();
            }
            return buffersToShift;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public byte next() {
        int expectedIndex = this.currentIndex;
        while (this.currentPos >= this.bufferSize) {
            this.currentPos -= this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex <= this.topIndex) {
            this.currentIndex = expectedIndex;
        } else {
            int indexShift = this.read(expectedIndex - this.topIndex);
            this.currentIndex = expectedIndex - indexShift;
        }
        byte b = this.buffers[this.currentIndex][this.currentPos];
        ++this.currentPos;
        ++this.absolutePos;
        return b;
    }

    @Override
    public byte lookahead() {
        return this.lookahead(0);
    }

    @Override
    public byte lookahead(int pos) {
        int expectedPos = this.currentPos + pos;
        int expectedIndex = this.currentIndex;
        while (expectedPos < 0) {
            expectedPos += this.bufferSize;
            --expectedIndex;
        }
        while (expectedPos >= this.bufferSize) {
            expectedPos -= this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex < 0) {
            throw new OutOfBufferException();
        }
        if (expectedIndex > this.topIndex) {
            int indexShift = this.readAhead(expectedIndex - this.topIndex);
            expectedIndex -= indexShift;
        }
        return this.buffers[expectedIndex][expectedPos];
    }

    @Override
    public byte prev() {
        int expectedIndex;
        --this.currentPos;
        --this.absolutePos;
        for (expectedIndex = this.currentIndex; this.currentPos < 0 && expectedIndex > -1; --expectedIndex) {
            this.currentPos += this.bufferSize;
        }
        if (expectedIndex < 0) {
            throw new OutOfBufferException();
        }
        this.currentIndex = expectedIndex;
        byte b = this.buffers[this.currentIndex][this.currentPos];
        return b;
    }

    @Override
    public byte lookbehind() {
        return this.lookbehind(0);
    }

    @Override
    public byte lookbehind(int pos) {
        int expectedPos = this.currentPos - 1 - pos;
        int expectedIndex = this.currentIndex;
        while (expectedPos < 0) {
            expectedPos += this.bufferSize;
            --expectedIndex;
        }
        while (expectedPos >= this.bufferSize) {
            expectedPos -= this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex < 0) {
            throw new OutOfBufferException();
        }
        if (expectedIndex > this.topIndex) {
            int indexShift = this.readAhead(expectedIndex - this.topIndex);
            expectedIndex -= indexShift;
        }
        return this.buffers[expectedIndex][expectedPos];
    }

    @Override
    public long current() {
        return this.absolutePos;
    }

    @Override
    public void move(long pos) {
        long relativePos = pos - this.absolutePos;
        long expectedPos = (long)this.currentPos + relativePos;
        int expectedIndex = this.currentIndex;
        while (expectedPos < 0L) {
            expectedPos += (long)this.bufferSize;
            --expectedIndex;
        }
        while (expectedPos >= (long)this.bufferSize) {
            expectedPos -= (long)this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex < 0) {
            throw new OutOfBufferException();
        }
        if (relativePos > 0L) {
            int buffersToRead = expectedIndex - this.topIndex;
            int indexShift = this.read(buffersToRead);
            this.currentIndex = expectedIndex - indexShift;
            this.currentPos = (int)expectedPos;
            this.absolutePos = pos;
        } else {
            this.currentIndex = expectedIndex;
            this.currentPos = (int)expectedPos;
            this.absolutePos = pos;
        }
    }

    @Override
    public void forward(int i) {
        this.move(this.absolutePos + (long)i);
    }

    @Override
    public void finish() {
        try {
            this.topPos = -1;
            this.currentIndex = this.topIndex;
            this.input.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public boolean finished() {
        return this.finished(0);
    }

    @Override
    public boolean finished(int i) {
        int indexShift;
        int expectedPos = this.currentPos + i;
        int expectedIndex = this.currentIndex;
        while (expectedPos > this.bufferSize) {
            expectedPos -= this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex > this.topIndex) {
            indexShift = this.readAhead(expectedIndex - this.topIndex);
            expectedIndex -= indexShift;
        }
        if (expectedIndex == this.topIndex && expectedPos == this.topPos && this.topPos == this.bufferSize) {
            indexShift = this.readAhead(1);
            expectedIndex -= indexShift;
        }
        if (this.topPos == -1 && expectedIndex >= this.topIndex) {
            return true;
        }
        if (this.topPos < this.bufferSize && expectedIndex == this.topIndex && expectedPos >= this.topPos) {
            return true;
        }
        return this.topPos == -1 && expectedIndex == this.topIndex - 1 && expectedPos == this.bufferSize;
    }

    @Override
    public byte at(long pos) {
        long relativePos = pos - this.absolutePos;
        long expectedPos = (long)this.currentPos + relativePos;
        int expectedIndex = this.currentIndex;
        while (expectedPos < 0L) {
            expectedPos += (long)this.bufferSize;
            --expectedIndex;
        }
        while (expectedPos >= (long)this.bufferSize) {
            expectedPos -= (long)this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex < 0) {
            throw new OutOfBufferException();
        }
        if (expectedIndex > this.topIndex) {
            int indexShift = this.readAhead(expectedIndex - this.topIndex);
            expectedIndex -= indexShift;
        }
        return this.buffers[expectedIndex][(int)expectedPos];
    }

    @Override
    public byte[] between(long start, long end) {
        long len = end - start;
        if (len == 0L) {
            return new byte[0];
        }
        if (len / (long)this.bufferSize > (long)this.bufferNumber) {
            throw new OutOfBufferException();
        }
        long relativeStart = start - this.absolutePos;
        long expectedStartPos = (long)this.currentPos + relativeStart;
        int expectedStartIndex = this.currentIndex;
        while (expectedStartPos < 0L) {
            expectedStartPos += (long)this.bufferSize;
            --expectedStartIndex;
        }
        while (expectedStartPos >= (long)this.bufferSize) {
            expectedStartPos -= (long)this.bufferSize;
            ++expectedStartIndex;
        }
        long relativeEnd = end - this.absolutePos;
        long expectedEndPos = (long)this.currentPos + relativeEnd;
        int expectedEndIndex = this.currentIndex;
        while (expectedEndPos <= 0L) {
            expectedEndPos += (long)this.bufferSize;
            --expectedEndIndex;
        }
        while (expectedEndPos > (long)this.bufferSize) {
            expectedEndPos -= (long)this.bufferSize;
            ++expectedEndIndex;
        }
        if (expectedStartIndex < 0 || expectedEndIndex < 0) {
            throw new OutOfBufferException();
        }
        if (expectedEndIndex - expectedStartIndex >= this.bufferNumber) {
            throw new OutOfBufferException();
        }
        if (expectedEndIndex > this.topIndex) {
            int indexShift = this.readAhead(expectedEndIndex - this.topIndex);
            expectedStartIndex -= indexShift;
            expectedEndIndex -= indexShift;
        }
        int betweenLen = (int)len;
        byte[] between = new byte[betweenLen];
        if (betweenLen != 0) {
            if (expectedStartIndex == expectedEndIndex) {
                System.arraycopy(this.buffers[expectedStartIndex], (int)expectedStartPos, between, 0, (int)(expectedEndPos - expectedStartPos));
            } else {
                int to = 0;
                System.arraycopy(this.buffers[expectedStartIndex], (int)expectedStartPos, between, to, (int)((long)this.bufferSize - expectedStartPos));
                to = (int)((long)to + ((long)this.bufferSize - expectedStartPos));
                for (int i = expectedStartIndex + 1; i < expectedEndIndex; ++i) {
                    System.arraycopy(this.buffers[i], 0, between, to, this.bufferSize);
                    to += this.bufferSize;
                }
                System.arraycopy(this.buffers[expectedEndIndex], 0, between, to, (int)expectedEndPos);
                to = (int)((long)to + expectedEndPos);
            }
        }
        return between;
    }

    @Override
    public ByteString slice(long start, long end) {
        return new ByteString(this.between(start, end), this.charset);
    }

    @Override
    public void mark() {
        this.mark = this.absolutePos;
    }

    @Override
    public boolean changed() {
        boolean changed = this.mark != Long.MIN_VALUE && this.mark != this.absolutePos;
        this.mark = Long.MIN_VALUE;
        return changed;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("...");
        long splitPoint = this.current();
        ByteString prefix = this.slice(this.startPoint(splitPoint), splitPoint);
        buffer.append(prefix.getMappablePrefix());
        ByteString suffix = this.slice(splitPoint, this.endPoint(splitPoint));
        if (!prefix.isMappable()) {
            buffer.append("~|~");
        } else {
            buffer.append('|');
        }
        buffer.append(suffix.getMappableSuffix());
        return buffer.toString();
    }

    public long endPoint(long splitPoint) {
        int lastPosRead;
        int n = lastPosRead = this.topPos > 0 ? this.topPos : 0;
        if (this.currentIndex < this.topIndex - 1) {
            return splitPoint - (long)this.currentPos + (long)(this.bufferSize * 2);
        }
        if (this.currentIndex < this.topIndex) {
            return splitPoint - (long)this.currentPos + (long)this.bufferSize + (long)lastPosRead;
        }
        return splitPoint - (long)this.currentPos + (long)lastPosRead;
    }

    public long startPoint(long splitPoint) {
        if (this.currentIndex > 0) {
            return splitPoint - (long)this.currentPos - (long)this.bufferSize;
        }
        return splitPoint - (long)this.currentPos;
    }
}

