/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.graph;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.amygdalum.util.graph.AbstractTraversal;
import net.amygdalum.util.graph.Graph;
import net.amygdalum.util.graph.GraphNode;
import net.amygdalum.util.graph.Traversal;

public abstract class ReversePostOrderWorklistTraversal<K, V>
extends AbstractTraversal<K, V>
implements Traversal<K, V> {
    private Class<V> clazz;
    private Set<GraphNode<K>> visited;
    private List<GraphNode<K>> ordered;
    private Set<GraphNode<K>> worklist;

    public ReversePostOrderWorklistTraversal(Graph<K> graph, Class<V> clazz) {
        super(graph);
        this.clazz = clazz;
        this.visited = new HashSet<GraphNode<K>>();
        this.ordered = new LinkedList<GraphNode<K>>();
    }

    @Override
    public void traverse() {
        super.traverse();
        this.worklist = new LinkedHashSet<GraphNode<K>>();
        this.worklist.addAll(this.getGraph().getNodes());
        while (!this.worklist.isEmpty()) {
            if (this.worklist.size() == 1) {
                Iterator<GraphNode<K>> iterator = this.worklist.iterator();
                GraphNode<K> node = iterator.next();
                iterator.remove();
                this.visitGraphNodeWorklist(node);
                continue;
            }
            for (GraphNode<K> node : this.ordered) {
                if (!this.worklist.contains(node)) continue;
                this.worklist.remove(node);
                this.visitGraphNodeWorklist(node);
            }
        }
    }

    private void visitGraphNodeWorklist(GraphNode<K> node) {
        V oldData = this.getData(node, this.clazz);
        this.visitGraphNode(node);
        V newData = this.getData(node, this.clazz);
        if (oldData == newData) {
            return;
        }
        if (oldData == null) {
            this.worklist.addAll(node.getSuccessors());
        } else if (newData == null) {
            this.worklist.addAll(node.getSuccessors());
        } else {
            if (oldData.equals(newData)) {
                return;
            }
            this.worklist.addAll(node.getSuccessors());
        }
    }

    @Override
    public void traverseNode(GraphNode<K> node) {
        if (!this.visited.contains(node)) {
            this.visited.add(node);
            for (GraphNode<K> next : node.getSuccessors()) {
                next.apply(this);
            }
            this.record(node);
        }
    }

    private void record(GraphNode<K> node) {
        this.ordered.add(0, node);
    }

    public abstract void visitGraphNode(GraphNode<K> var1);
}

