/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.graph;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.amygdalum.util.graph.AbstractTraversal;
import net.amygdalum.util.graph.Graph;
import net.amygdalum.util.graph.GraphNode;
import net.amygdalum.util.graph.Traversal;

public abstract class ReversePostOrderTraversal<K, V>
extends AbstractTraversal<K, V>
implements Traversal<K, V> {
    private Set<GraphNode<K>> visited = new HashSet<GraphNode<K>>();
    private List<GraphNode<K>> ordered = new LinkedList<GraphNode<K>>();

    public ReversePostOrderTraversal(Graph<K> graph) {
        super(graph);
    }

    @Override
    public void traverse() {
        super.traverse();
        for (GraphNode<K> node : this.ordered) {
            this.visitGraphNode(node);
        }
    }

    @Override
    public void traverseNode(GraphNode<K> node) {
        if (!this.visited.contains(node)) {
            this.visited.add(node);
            for (GraphNode<K> next : node.getSuccessors()) {
                next.apply(this);
            }
            this.record(node);
        }
    }

    private void record(GraphNode<K> node) {
        this.ordered.add(0, node);
    }

    public abstract void visitGraphNode(GraphNode<K> var1);
}

