/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.graph;

import java.util.HashSet;
import java.util.Set;
import net.amygdalum.util.graph.AbstractTraversal;
import net.amygdalum.util.graph.Graph;
import net.amygdalum.util.graph.GraphNode;
import net.amygdalum.util.graph.Traversal;

public abstract class PreOrderTraversal<K, V>
extends AbstractTraversal<K, V>
implements Traversal<K, V> {
    private Set<GraphNode<K>> visited = new HashSet<GraphNode<K>>();

    public PreOrderTraversal(Graph<K> graph) {
        super(graph);
    }

    @Override
    public void traverse() {
        super.traverse();
    }

    @Override
    public void traverseNode(GraphNode<K> node) {
        if (!this.visited.contains(node)) {
            this.visited.add(node);
            this.visitGraphNode(node);
            for (GraphNode<K> next : node.getSuccessors()) {
                next.apply(this);
            }
        }
    }

    public abstract void visitGraphNode(GraphNode<K> var1);
}

