/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.graph;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.amygdalum.util.graph.GraphNode;

public class Graph<K> {
    private GraphNode<K> root;
    private Map<K, GraphNode<K>> nodes = new LinkedHashMap<K, GraphNode<K>>();

    public GraphNode<K> getRoot() {
        return this.root;
    }

    public GraphNode<K> createRoot(K key) {
        this.root = this.createNode(key);
        return this.root;
    }

    public GraphNode<K> getNode(K key) {
        return this.nodes.get(key);
    }

    public GraphNode<K> createNode(K key) {
        GraphNode<K> node = this.nodes.get(key);
        if (node == null) {
            node = new GraphNode<K>(key);
            this.nodes.put(key, node);
        }
        return node;
    }

    public Collection<GraphNode<K>> getNodes() {
        return this.nodes.values();
    }

    public void connectNodes(K from, K to) {
        GraphNode<K> toNode = this.nodes.get(to);
        GraphNode<K> fromNode = this.nodes.get(from);
        fromNode.addSuccessor(toNode);
        toNode.addPredecessor(fromNode);
    }
}

