/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.builders;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import net.amygdalum.util.builders.Predicate;

public class TreeSets<T> {
    private TreeSet<T> set;

    private TreeSets() {
        this.set = new TreeSet();
    }

    private TreeSets(Comparator<? super T> comparator) {
        this.set = new TreeSet<T>(comparator);
    }

    private TreeSets(Collection<? extends T> set) {
        this.set = new TreeSet<T>(set);
    }

    private TreeSets(Collection<? extends T> set, Comparator<? super T> comparator) {
        this.set = new TreeSet<T>(comparator);
        this.set.addAll(set);
    }

    public static <T> TreeSets<T> sorted() {
        return new TreeSets<T>();
    }

    public static <T> TreeSets<T> sorted(Comparator<? super T> comparator) {
        return new TreeSets<T>(comparator);
    }

    public static <T> TreeSets<T> sorted(Collection<T> set) {
        return new TreeSets<T>(set);
    }

    public static <T> TreeSets<T> empty() {
        return new TreeSets<T>();
    }

    public static <T> TreeSets<T> empty(Comparator<? super T> comparator) {
        return new TreeSets<T>(comparator);
    }

    @SafeVarargs
    public static <T> TreeSet<T> of(T ... elements) {
        return new TreeSet<T>(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <T> TreeSet<T> of(Predicate<T> cond, T ... elements) {
        TreeSet<T> list = new TreeSet<T>();
        for (T element : elements) {
            if (!cond.evaluate(element)) continue;
            list.add(element);
        }
        return list;
    }

    public static <T> TreeSet<T> intersectionOf(Set<T> set, Set<T> other) {
        return new TreeSets<T>(set).intersect(other).build();
    }

    public static <T> TreeSet<T> unionOf(Set<T> set, Set<T> other) {
        return new TreeSets<T>(set).union(other).build();
    }

    public static <T> TreeSet<T> complementOf(Set<T> set, Set<T> minus) {
        return new TreeSets<T>(set).minus(minus).build();
    }

    public TreeSets<T> union(Set<T> add) {
        return this.addAll(add);
    }

    public TreeSets<T> add(T add) {
        this.set.add(add);
        return this;
    }

    public TreeSets<T> addConditional(boolean b, T add) {
        if (b) {
            this.set.add(add);
        }
        return this;
    }

    public TreeSets<T> addAll(Set<T> add) {
        this.set.addAll(add);
        return this;
    }

    public TreeSets<T> addAll(T ... add) {
        this.set.addAll(Arrays.asList(add));
        return this;
    }

    public TreeSets<T> minus(Set<T> remove) {
        return this.removeAll(remove);
    }

    public TreeSets<T> remove(T remove) {
        this.set.remove(remove);
        return this;
    }

    public TreeSets<T> removeConditional(boolean b, T remove) {
        if (b) {
            this.set.remove(remove);
        }
        return this;
    }

    public TreeSets<T> removeAll(Set<T> remove) {
        this.set.removeAll(remove);
        return this;
    }

    public TreeSets<T> removeAll(T ... remove) {
        this.set.removeAll(Arrays.asList(remove));
        return this;
    }

    public TreeSets<T> intersect(Set<T> retain) {
        return this.retainAll(retain);
    }

    public TreeSets<T> retain(T retain) {
        HashSet<T> retainAll = new HashSet<T>();
        retainAll.add(retain);
        this.set.retainAll(retainAll);
        return this;
    }

    public TreeSets<T> retainConditional(boolean b, T retain) {
        if (b) {
            HashSet<T> retainAll = new HashSet<T>();
            retainAll.add(retain);
            this.set.retainAll(retainAll);
        }
        return this;
    }

    public TreeSets<T> retainAll(Set<T> retain) {
        this.set.retainAll(retain);
        return this;
    }

    public TreeSets<T> retainAll(T ... retain) {
        this.set.retainAll(Arrays.asList(retain));
        return this;
    }

    public TreeSet<T> build() {
        return this.set;
    }
}

