/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.builders;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.amygdalum.util.builders.Predicate;

public class HashSets<T> {
    private HashSet<T> set;

    private HashSets(boolean linked) {
        this.set = linked ? new LinkedHashSet<T>() : new HashSet();
    }

    private HashSets(Collection<? extends T> set, boolean linked) {
        this.set = linked ? new LinkedHashSet<T>(set) : new HashSet<T>(set);
    }

    public static <T> HashSets<T> linked() {
        return new HashSets<T>(true);
    }

    public static <T> HashSets<T> linked(Collection<T> set) {
        return new HashSets<T>(set, true);
    }

    public static <T> HashSets<T> hashed() {
        return new HashSets<T>(false);
    }

    public static <T> HashSets<T> hashed(Collection<T> set) {
        return new HashSets<T>(set, false);
    }

    public static <T> HashSets<T> empty() {
        return new HashSets<T>(false);
    }

    @SafeVarargs
    public static <T> HashSet<T> of(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <T> HashSet<T> of(Predicate<T> cond, T ... elements) {
        HashSet<T> list = new HashSet<T>();
        for (T element : elements) {
            if (!cond.evaluate(element)) continue;
            list.add(element);
        }
        return list;
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> ofLinked(T ... elements) {
        return new LinkedHashSet<T>(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> ofLinked(Predicate<T> cond, T ... elements) {
        LinkedHashSet<T> list = new LinkedHashSet<T>();
        for (T element : elements) {
            if (!cond.evaluate(element)) continue;
            list.add(element);
        }
        return list;
    }

    public static <T> HashSet<T> intersectionOf(Set<T> set, Set<T> other) {
        return new HashSets<T>(set, false).intersect(other).build();
    }

    public static <T> HashSet<T> unionOf(Set<T> set, Set<T> other) {
        return new HashSets<T>(set, false).union(other).build();
    }

    public static <T> HashSet<T> complementOf(Set<T> set, Set<T> minus) {
        return new HashSets<T>(set, false).minus(minus).build();
    }

    public HashSets<T> union(Set<T> add) {
        return this.addAll(add);
    }

    public HashSets<T> add(T add) {
        this.set.add(add);
        return this;
    }

    public HashSets<T> addConditional(boolean b, T add) {
        if (b) {
            this.set.add(add);
        }
        return this;
    }

    public HashSets<T> addAll(Set<T> add) {
        this.set.addAll(add);
        return this;
    }

    public HashSets<T> addAll(T ... add) {
        this.set.addAll(Arrays.asList(add));
        return this;
    }

    public HashSets<T> minus(Set<T> remove) {
        return this.removeAll(remove);
    }

    public HashSets<T> remove(T remove) {
        this.set.remove(remove);
        return this;
    }

    public HashSets<T> removeConditional(boolean b, T remove) {
        if (b) {
            this.set.remove(remove);
        }
        return this;
    }

    public HashSets<T> removeAll(Set<T> remove) {
        this.set.removeAll(remove);
        return this;
    }

    public HashSets<T> removeAll(T ... remove) {
        this.set.removeAll(Arrays.asList(remove));
        return this;
    }

    public HashSets<T> intersect(Set<T> retain) {
        return this.retainAll(retain);
    }

    public HashSets<T> retain(T retain) {
        HashSet<T> retainAll = new HashSet<T>();
        retainAll.add(retain);
        this.set.retainAll(retainAll);
        return this;
    }

    public HashSets<T> retainConditional(boolean b, T retain) {
        if (b) {
            HashSet<T> retainAll = new HashSet<T>();
            retainAll.add(retain);
            this.set.retainAll(retainAll);
        }
        return this;
    }

    public HashSets<T> retainAll(Set<T> retain) {
        this.set.retainAll(retain);
        return this;
    }

    public HashSets<T> retainAll(T ... retain) {
        this.set.retainAll(Arrays.asList(retain));
        return this;
    }

    public HashSet<T> build() {
        return this.set;
    }
}

