/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Arrays<T> {
    private List<T> base;

    private Arrays(List<T> base) {
        this.base = base;
    }

    public static <T> Arrays<T> init(int size) {
        return new Arrays(new ArrayList(size));
    }

    public static char[] fromWrapped(Collection<Character> charlist) {
        char[] chars = new char[charlist.size()];
        int i = 0;
        for (Character c : charlist) {
            chars[i] = c.charValue();
            ++i;
        }
        return chars;
    }

    public Arrays<T> add(T item) {
        this.base.add(item);
        return this;
    }

    public Arrays<T> addAll(T[] items) {
        for (T item : items) {
            this.base.add(item);
        }
        return this;
    }

    public Arrays<T> addAll(List<T> items) {
        this.base.addAll(items);
        return this;
    }

    public T[] build(T[] a) {
        return this.base.toArray(a);
    }
}

