/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.amygdalum.util.builders.Predicate;

public class ArrayLists<T> {
    private ArrayList<T> list;

    private ArrayLists() {
        this.list = new ArrayList();
    }

    private ArrayLists(Collection<? extends T> list) {
        this.list = new ArrayList<T>(list);
    }

    @SafeVarargs
    public static <T> ArrayLists<T> list(T ... elements) {
        return new ArrayLists<T>(Arrays.asList(elements));
    }

    public static <T> ArrayLists<T> empty() {
        return new ArrayLists<T>();
    }

    @SafeVarargs
    public static <T> ArrayList<T> of(T ... elements) {
        return new ArrayList<T>(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <T> ArrayList<T> of(Predicate<T> cond, T ... elements) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : elements) {
            if (!cond.evaluate(element)) continue;
            list.add(element);
        }
        return list;
    }

    public static ArrayList<Integer> ofPrimitives(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int i : array) {
            list.add(i);
        }
        return list;
    }

    public ArrayLists<T> add(T add) {
        this.list.add(add);
        return this;
    }

    public ArrayLists<T> addConditional(boolean b, T add) {
        this.list.add(add);
        return this;
    }

    public ArrayLists<T> addAll(T ... add) {
        this.list.addAll(Arrays.asList(add));
        return this;
    }

    public ArrayLists<T> addAll(List<T> add) {
        this.list.addAll(add);
        return this;
    }

    public ArrayLists<T> remove(T remove) {
        this.list.remove(remove);
        return this;
    }

    public ArrayLists<T> removeConditional(boolean b, T remove) {
        if (b) {
            this.list.remove(remove);
        }
        return this;
    }

    public ArrayLists<T> removeAll(T ... remove) {
        this.list.removeAll(Arrays.asList(remove));
        return this;
    }

    public ArrayLists<T> removeAll(List<T> remove) {
        this.list.removeAll(remove);
        return this;
    }

    public ArrayLists<T> retain(T retain) {
        HashSet<T> retainAll = new HashSet<T>();
        retainAll.add(retain);
        this.list.retainAll(retainAll);
        return this;
    }

    public ArrayLists<T> retainConditional(boolean b, T retain) {
        if (b) {
            HashSet<T> retainAll = new HashSet<T>();
            retainAll.add(retain);
            this.list.retainAll(retainAll);
        }
        return this;
    }

    public ArrayLists<T> retainAll(List<T> retain) {
        this.list.retainAll(retain);
        return this;
    }

    public ArrayLists<T> retainAll(T ... retain) {
        this.list.retainAll(Arrays.asList(retain));
        return this;
    }

    public ArrayList<T> build() {
        return this.list;
    }
}

