/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.vanilla.internal;

import java.math.BigInteger;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import net.adoptopenjdk.v3.api.AOV3Architecture;
import net.adoptopenjdk.v3.api.AOV3Exception;
import net.adoptopenjdk.v3.api.AOV3HeapSize;
import net.adoptopenjdk.v3.api.AOV3ImageKind;
import net.adoptopenjdk.v3.api.AOV3JVMImplementation;
import net.adoptopenjdk.v3.api.AOV3OperatingSystem;
import net.adoptopenjdk.v3.api.AOV3ReleaseKind;
import net.adoptopenjdk.v3.api.AOV3RequestBinaryForLatestType;
import net.adoptopenjdk.v3.api.AOV3Vendor;
import net.adoptopenjdk.v3.vanilla.internal.AOV3Client;

final class AOV3RequestBinaryForLatest
implements AOV3RequestBinaryForLatestType {
    private final AOV3Client client;
    private final AOV3Architecture architecture;
    private final BigInteger version;
    private final AOV3HeapSize heapSize;
    private final AOV3ImageKind imageKind;
    private final AOV3JVMImplementation jvmImplementation;
    private final AOV3OperatingSystem operatingSystem;
    private final AOV3ReleaseKind releaseKind;
    private final AOV3Vendor vendor;
    private final Optional<String> project;

    AOV3RequestBinaryForLatest(AOV3Client inClient, AOV3Architecture inArchitecture, BigInteger inVersion, AOV3HeapSize inHeapSize, AOV3ImageKind inImageKind, AOV3JVMImplementation inJvmImplementation, AOV3OperatingSystem inOperatingSystem, AOV3ReleaseKind inReleaseKind, AOV3Vendor inVendor, Optional<String> inProject) {
        this.client = Objects.requireNonNull(inClient, "inClient");
        this.architecture = Objects.requireNonNull(inArchitecture, "inArchitecture");
        this.version = Objects.requireNonNull(inVersion, "inVersion");
        this.heapSize = Objects.requireNonNull(inHeapSize, "inHeapSize");
        this.imageKind = Objects.requireNonNull(inImageKind, "inImageKind");
        this.jvmImplementation = Objects.requireNonNull(inJvmImplementation, "inJvmImplementation");
        this.operatingSystem = Objects.requireNonNull(inOperatingSystem, "inOperatingSystem");
        this.releaseKind = Objects.requireNonNull(inReleaseKind, "inReleaseKind");
        this.vendor = Objects.requireNonNull(inVendor, "inVendor");
        this.project = Objects.requireNonNull(inProject, "inProject");
    }

    public URI execute() throws AOV3Exception, InterruptedException {
        StringBuilder uriBuilder = new StringBuilder(128);
        uriBuilder.append(this.client.baseURI());
        uriBuilder.append("/binary/latest/");
        uriBuilder.append(this.version);
        uriBuilder.append("/");
        uriBuilder.append(this.releaseKind.nameText());
        uriBuilder.append("/");
        uriBuilder.append(this.operatingSystem.nameText());
        uriBuilder.append("/");
        uriBuilder.append(this.architecture.nameText());
        uriBuilder.append("/");
        uriBuilder.append(this.imageKind.nameText());
        uriBuilder.append("/");
        uriBuilder.append(this.jvmImplementation.nameText());
        uriBuilder.append("/");
        uriBuilder.append(this.heapSize.nameText());
        uriBuilder.append("/");
        uriBuilder.append(this.vendor.nameText());
        this.project.ifPresent(name -> {
            uriBuilder.append("?project=");
            uriBuilder.append((String)name);
        });
        return this.client.uriFor(uriBuilder.toString());
    }
}

