/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.vanilla.internal;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.adoptopenjdk.v3.api.AOV3Error;
import net.adoptopenjdk.v3.api.AOV3Exception;
import net.adoptopenjdk.v3.api.AOV3JVMImplementation;
import net.adoptopenjdk.v3.api.AOV3ListBinaryAssetView;
import net.adoptopenjdk.v3.api.AOV3RequestAssetsForLatestType;
import net.adoptopenjdk.v3.vanilla.internal.AOV3ClientInternalType;

public final class AOV3RequestAssetsForLatest
implements AOV3RequestAssetsForLatestType {
    private final AOV3ClientInternalType client;
    private final AOV3JVMImplementation jvmImplementation;
    private final BigInteger version;
    private final Consumer<AOV3Error> errorReceiver;

    AOV3RequestAssetsForLatest(AOV3ClientInternalType inClient, Consumer<AOV3Error> inErrorReceiver, BigInteger inVersion, AOV3JVMImplementation inJvmImplementation) {
        this.client = Objects.requireNonNull(inClient, "inClient");
        this.errorReceiver = Objects.requireNonNull(inErrorReceiver, "errorReceiver");
        this.version = Objects.requireNonNull(inVersion, "version");
        this.jvmImplementation = Objects.requireNonNull(inJvmImplementation, "jvmImplementation");
    }

    public List<AOV3ListBinaryAssetView> execute() throws AOV3Exception, InterruptedException {
        StringBuilder uriBuilder = new StringBuilder(128);
        uriBuilder.append(this.client.baseURI());
        uriBuilder.append("/assets/latest/");
        uriBuilder.append(this.version);
        uriBuilder.append("/");
        uriBuilder.append(this.jvmImplementation.nameText());
        return this.client.parserFor(this.errorReceiver, uriBuilder.toString()).parseAssetsForLatest();
    }
}

