/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.vanilla.internal;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.adoptopenjdk.v3.api.AOV3Architecture;
import net.adoptopenjdk.v3.api.AOV3Error;
import net.adoptopenjdk.v3.api.AOV3Exception;
import net.adoptopenjdk.v3.api.AOV3HeapSize;
import net.adoptopenjdk.v3.api.AOV3ImageKind;
import net.adoptopenjdk.v3.api.AOV3JVMImplementation;
import net.adoptopenjdk.v3.api.AOV3OperatingSystem;
import net.adoptopenjdk.v3.api.AOV3Release;
import net.adoptopenjdk.v3.api.AOV3ReleaseKind;
import net.adoptopenjdk.v3.api.AOV3RequestAssetsForReleaseType;
import net.adoptopenjdk.v3.api.AOV3SortOrder;
import net.adoptopenjdk.v3.api.AOV3Vendor;
import net.adoptopenjdk.v3.vanilla.internal.AOV3ClientInternalType;

final class AOV3RequestAssetsForRelease
implements AOV3RequestAssetsForReleaseType {
    private final AOV3ClientInternalType client;
    private final Consumer<AOV3Error> errorReceiver;
    private final BigInteger page;
    private final BigInteger pageSize;
    private final BigInteger version;
    private final AOV3ReleaseKind releaseKind;
    private final Optional<AOV3Architecture> architecture;
    private final Optional<AOV3HeapSize> heapSize;
    private final Optional<AOV3ImageKind> imageKind;
    private final Optional<AOV3JVMImplementation> jvmImplementation;
    private final Optional<AOV3OperatingSystem> operatingSystem;
    private final Optional<String> project;
    private final Optional<AOV3SortOrder> sortOrder;
    private final Optional<AOV3Vendor> vendor;

    AOV3RequestAssetsForRelease(AOV3ClientInternalType inClient, Consumer<AOV3Error> inErrorReceiver, BigInteger inPage, BigInteger inPageSize, BigInteger inVersion, AOV3ReleaseKind inReleaseKind, Optional<AOV3Architecture> inArchitecture, Optional<AOV3HeapSize> inHeapSize, Optional<AOV3ImageKind> inImageKind, Optional<AOV3JVMImplementation> inJvmImplementation, Optional<AOV3OperatingSystem> inOperatingSystem, Optional<String> inProject, Optional<AOV3SortOrder> inSortOrder, Optional<AOV3Vendor> inVendor) {
        this.client = Objects.requireNonNull(inClient, "client");
        this.errorReceiver = Objects.requireNonNull(inErrorReceiver, "errorReceiver");
        this.page = Objects.requireNonNull(inPage, "page");
        this.pageSize = Objects.requireNonNull(inPageSize, "pageSize");
        this.version = Objects.requireNonNull(inVersion, "version");
        this.releaseKind = Objects.requireNonNull(inReleaseKind, "releaseKind");
        this.architecture = Objects.requireNonNull(inArchitecture, "architecture");
        this.heapSize = Objects.requireNonNull(inHeapSize, "heapSize");
        this.imageKind = Objects.requireNonNull(inImageKind, "imageKind");
        this.jvmImplementation = Objects.requireNonNull(inJvmImplementation, "jvmImplementation");
        this.operatingSystem = Objects.requireNonNull(inOperatingSystem, "operatingSystem");
        this.project = Objects.requireNonNull(inProject, "project");
        this.sortOrder = Objects.requireNonNull(inSortOrder, "sortOrder");
        this.vendor = Objects.requireNonNull(inVendor, "vendor");
    }

    public List<AOV3Release> execute() throws AOV3Exception, InterruptedException {
        StringBuilder uriBuilder = new StringBuilder(128);
        uriBuilder.append(this.client.baseURI());
        uriBuilder.append("/assets/feature_releases/");
        uriBuilder.append(this.version);
        uriBuilder.append("/");
        uriBuilder.append(this.releaseKind.nameText());
        uriBuilder.append("?page=");
        uriBuilder.append(this.page);
        uriBuilder.append("&page_size=");
        uriBuilder.append(this.pageSize);
        this.architecture.ifPresent(kind -> {
            uriBuilder.append("&architecture=");
            uriBuilder.append(kind.nameText());
        });
        this.heapSize.ifPresent(kind -> {
            uriBuilder.append("&heap_size=");
            uriBuilder.append(kind.nameText());
        });
        this.imageKind.ifPresent(kind -> {
            uriBuilder.append("&image_type=");
            uriBuilder.append(kind.nameText());
        });
        this.jvmImplementation.ifPresent(kind -> {
            uriBuilder.append("&jvm_impl=");
            uriBuilder.append(kind.nameText());
        });
        this.operatingSystem.ifPresent(kind -> {
            uriBuilder.append("&os=");
            uriBuilder.append(kind.nameText());
        });
        this.project.ifPresent(kind -> {
            uriBuilder.append("&project=");
            uriBuilder.append((String)kind);
        });
        this.sortOrder.ifPresent(kind -> {
            uriBuilder.append("&sort_order=");
            uriBuilder.append(kind.nameText());
        });
        this.vendor.ifPresent(kind -> {
            uriBuilder.append("&vendor=");
            uriBuilder.append(kind.nameText());
        });
        return this.client.parserFor(this.errorReceiver, uriBuilder.toString()).parseAssetsForRelease();
    }
}

