/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.vanilla.internal;

import java.net.URI;
import java.net.http.HttpClient;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import net.adoptopenjdk.v3.vanilla.internal.AOV3MessagesType;

public final class AOV3Messages
implements AOV3MessagesType {
    private final ResourceBundle resourceBundle;

    private AOV3Messages(ResourceBundle inResourceBundle) {
        this.resourceBundle = inResourceBundle;
    }

    public static ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("net.adoptopenjdk.v3.vanilla.internal.Strings", locale);
    }

    public static ResourceBundle getResourceBundle() {
        return AOV3Messages.getResourceBundle(Locale.getDefault());
    }

    public static AOV3MessagesType of(ResourceBundle bundle) {
        return new AOV3Messages(bundle);
    }

    @Override
    public ResourceBundle resourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public String format(String id, Object ... args) {
        return MessageFormat.format(this.resourceBundle.getString(id), args);
    }

    @Override
    public String httpClientNoRedirects(HttpClient.Redirect followRedirects) {
        return this.format("http.clientMisconfigured", new Object[]{followRedirects});
    }

    @Override
    public String locationMissing(int statusCode, URI uri) {
        return this.format("http.locationMissing", uri, statusCode);
    }

    @Override
    public String requestFailed(int statusCode, URI uri) {
        return this.format("http.requestFailed", uri, statusCode);
    }
}

