/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.vanilla.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.adoptopenjdk.v3.api.AOV3Architecture;
import net.adoptopenjdk.v3.api.AOV3AvailableReleases;
import net.adoptopenjdk.v3.api.AOV3Binary;
import net.adoptopenjdk.v3.api.AOV3BinaryType;
import net.adoptopenjdk.v3.api.AOV3Error;
import net.adoptopenjdk.v3.api.AOV3ExceptionParseFailed;
import net.adoptopenjdk.v3.api.AOV3HeapSize;
import net.adoptopenjdk.v3.api.AOV3ImageKind;
import net.adoptopenjdk.v3.api.AOV3Installer;
import net.adoptopenjdk.v3.api.AOV3JVMImplementation;
import net.adoptopenjdk.v3.api.AOV3ListBinaryAssetView;
import net.adoptopenjdk.v3.api.AOV3OperatingSystem;
import net.adoptopenjdk.v3.api.AOV3Package;
import net.adoptopenjdk.v3.api.AOV3PackageType;
import net.adoptopenjdk.v3.api.AOV3Release;
import net.adoptopenjdk.v3.api.AOV3ReleaseKind;
import net.adoptopenjdk.v3.api.AOV3Source;
import net.adoptopenjdk.v3.api.AOV3Vendor;
import net.adoptopenjdk.v3.api.AOV3VersionData;
import net.adoptopenjdk.v3.vanilla.internal.AOV3AST;
import net.adoptopenjdk.v3.vanilla.internal.AOV3ResponseParserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AOV3ResponseParser
implements AOV3ResponseParserType {
    private static final Logger LOG = LoggerFactory.getLogger(AOV3ResponseParser.class);
    private final URI source;
    private final InputStream stream;
    private final Consumer<AOV3Error> errorReceiver;
    private final ObjectMapper objectMapper;

    public AOV3ResponseParser(Consumer<AOV3Error> inErrorReceiver, ObjectMapper inObjectMapper, URI inSource, InputStream inStream) {
        this.errorReceiver = Objects.requireNonNull(inErrorReceiver, "errorReceiver");
        this.objectMapper = Objects.requireNonNull(inObjectMapper, "objectMapper");
        this.source = Objects.requireNonNull(inSource, "source");
        this.stream = Objects.requireNonNull(inStream, "stream");
    }

    private static AOV3Binary toBinary(AOV3AST.AOV3BinaryJSON binary) {
        AOV3Architecture architecture = AOV3Architecture.of((String)Objects.requireNonNull(binary.architecture, "binary.architecture"));
        BigInteger downloadCount = Objects.requireNonNull(binary.downloadCount, "binary.downloadCount");
        AOV3HeapSize heapSize = AOV3HeapSize.of((String)Objects.requireNonNull(binary.heapSize, "binary.heapSize"));
        AOV3ImageKind imageType = AOV3ImageKind.of((String)Objects.requireNonNull(binary.imageType, "binary.imageType"));
        AOV3JVMImplementation jvmImplementation = AOV3JVMImplementation.of((String)Objects.requireNonNull(binary.jvmImplementation, "binary.jvmImplementation"));
        AOV3OperatingSystem operatingSystem = AOV3OperatingSystem.of((String)Objects.requireNonNull(binary.operatingSystem, "binary.operatingSystem"));
        Optional<AOV3Installer> installer = Optional.ofNullable(binary.installer).map(AOV3ResponseParser::toInstaller);
        Optional<String> scmReference = Optional.ofNullable(binary.scmReference);
        return AOV3Binary.builder().setArchitecture(architecture).setDownloadCount(downloadCount).setHeapSize(heapSize).setImageType(imageType).setInstaller(installer).setJvmImplementation(jvmImplementation).setOperatingSystem(operatingSystem).setPackage_((AOV3PackageType)AOV3ResponseParser.toPackage(binary.package_)).setProject(binary.project).setScmReference(scmReference).setUpdatedAt(AOV3ResponseParser.toOffsetDateTime(binary.updatedAt)).build();
    }

    private static AOV3Installer toInstaller(AOV3AST.AOV3InstallerJSON installer) {
        Optional<String> checksum = Optional.ofNullable(installer.checksum);
        Optional<URI> checksumLink = Optional.ofNullable(installer.checksumLink);
        BigInteger downloadCount = Objects.requireNonNull(installer.downloadCount, "installer.downloadCount");
        URI link = Objects.requireNonNull(installer.link, "installer.link");
        String name = Objects.requireNonNull(installer.name, "installer.name");
        Optional<URI> signatureLink = Optional.ofNullable(installer.signatureLink);
        BigInteger size = Objects.requireNonNull(installer.size, "installer.size");
        return AOV3Installer.builder().setChecksum(checksum).setChecksumLink(checksumLink).setDownloadCount(downloadCount).setLink(link).setName(name).setSignatureLink(signatureLink).setSize(size).build();
    }

    private static AOV3Package toPackage(AOV3AST.AOV3PackageJSON package_) {
        Optional<String> checksum = Optional.ofNullable(package_.checksum);
        Optional<URI> checksumLink = Optional.ofNullable(package_.checksumLink);
        BigInteger downloadCount = Objects.requireNonNull(package_.downloadCount, "package_.downloadCount");
        URI link = Objects.requireNonNull(package_.link, "package_.link");
        String name = Objects.requireNonNull(package_.name, "package_.name");
        Optional<URI> signatureLink = Optional.ofNullable(package_.signatureLink);
        BigInteger size = Objects.requireNonNull(package_.size, "package_.size");
        return AOV3Package.builder().setChecksum(checksum).setChecksumLink(checksumLink).setDownloadCount(downloadCount).setLink(link).setName(name).setSignatureLink(signatureLink).setSize(size).build();
    }

    private static AOV3VersionData toVersionData(AOV3AST.AOV3ReleaseVersionJSON versionData) {
        return AOV3VersionData.builder().setAdoptBuildNumber(versionData.adoptBuildNumber).setBuild(versionData.build).setMajor(versionData.major).setMinor(versionData.minor).setOpenJDKVersion(versionData.openjdkVersion).setOptional(versionData.optional).setPre(versionData.pre).setSecurity(versionData.security).setSemanticVersion(versionData.semver).build();
    }

    private static AOV3Vendor toVendor(String vendor) {
        return AOV3Vendor.of((String)Objects.requireNonNull(vendor, "vendor"));
    }

    private static OffsetDateTime toOffsetDateTime(String text) {
        return OffsetDateTime.parse(text, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private static AOV3Source toSource(AOV3AST.AOV3SourceJSON source) {
        return AOV3Source.builder().setLink(source.link).setName(source.name).setSize(source.size).build();
    }

    private AOV3Release toRelease(AOV3AST.AOV3ReleaseJSON release) {
        AOV3Release.Builder builder = AOV3Release.builder();
        BigInteger downloadCount = Objects.requireNonNull(release.downloadCount, "release.downloadCount");
        String id = Objects.requireNonNull(release.id, "release.id");
        URI releaseLink = Objects.requireNonNull(release.releaseLink, "release.releaseLink");
        String releaseName = Objects.requireNonNull(release.releaseName, "release.releaseName");
        AOV3ReleaseKind of = AOV3ReleaseKind.of((String)Objects.requireNonNull(release.releaseType, "release.releaseType"));
        OffsetDateTime timestamp = AOV3ResponseParser.toOffsetDateTime(Objects.requireNonNull(release.timestamp, "release.timestamp"));
        OffsetDateTime updatedAt = AOV3ResponseParser.toOffsetDateTime(Objects.requireNonNull(release.updatedAt, "release.updatedAt"));
        AOV3Vendor vendor = AOV3ResponseParser.toVendor(Objects.requireNonNull(release.vendor, "release.vendor"));
        AOV3VersionData versionData = AOV3ResponseParser.toVersionData(Objects.requireNonNull(release.versionData, "release.versionData"));
        Optional<AOV3Source> releaseSource = Optional.ofNullable(release.source).map(AOV3ResponseParser::toSource);
        builder.setDownloadCount(downloadCount).setId(id).setReleaseLink(releaseLink).setReleaseName(releaseName).setReleaseType(of).setSource(releaseSource).setTimestamp(timestamp).setUpdatedAt(updatedAt).setVendor(vendor).setVersionData(versionData);
        for (AOV3AST.AOV3BinaryJSON binary : release.binaries) {
            try {
                builder.addBinaries((AOV3BinaryType)AOV3ResponseParser.toBinary(binary));
            }
            catch (Exception e) {
                LOG.error("exception raised during binary parsing: ", (Throwable)e);
                this.errorReceiver.accept(AOV3Error.builder().setContext("binary").setException(e).setMessage(e.getMessage()).setSource(this.source).build());
            }
        }
        return builder.build();
    }

    @Override
    public AOV3AvailableReleases parseAvailableReleases() throws AOV3ExceptionParseFailed {
        AOV3AvailableReleases aOV3AvailableReleases;
        block8: {
            JsonFactory factory = this.objectMapper.getFactory();
            JsonParser parser = factory.createParser(this.stream);
            try {
                AOV3AST.AOV3AvailableReleasesJSON ast = (AOV3AST.AOV3AvailableReleasesJSON)this.objectMapper.readValue(parser, AOV3AST.AOV3AvailableReleasesJSON.class);
                aOV3AvailableReleases = AOV3AvailableReleases.builder().addAllAvailableLTSReleases(ast.availableLTSReleases).addAllAvailableReleases(ast.availableReleases).setMostRecentFeatureRelease(ast.mostRecentFeatureRelease).setMostRecentLTSRelease(ast.mostRecentLTS).build();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AOV3ExceptionParseFailed((Throwable)e);
                }
            }
            parser.close();
        }
        return aOV3AvailableReleases;
    }

    @Override
    public List<String> parseReleaseNames() throws AOV3ExceptionParseFailed {
        List<String> list;
        block8: {
            JsonFactory factory = this.objectMapper.getFactory();
            JsonParser parser = factory.createParser(this.stream);
            try {
                AOV3AST.AOV3ReleaseNamesJSON ast = (AOV3AST.AOV3ReleaseNamesJSON)this.objectMapper.readValue(parser, AOV3AST.AOV3ReleaseNamesJSON.class);
                list = List.copyOf(ast.releases);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AOV3ExceptionParseFailed((Throwable)e);
                }
            }
            parser.close();
        }
        return list;
    }

    @Override
    public List<AOV3VersionData> parseReleaseVersions() throws AOV3ExceptionParseFailed {
        List<AOV3VersionData> list;
        block8: {
            JsonFactory factory = this.objectMapper.getFactory();
            JsonParser parser = factory.createParser(this.stream);
            try {
                AOV3AST.AOV3ReleaseVersionsJSON ast = (AOV3AST.AOV3ReleaseVersionsJSON)this.objectMapper.readValue(parser, AOV3AST.AOV3ReleaseVersionsJSON.class);
                list = ast.versions.stream().flatMap(this::tryToVersionData).collect(Collectors.toList());
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AOV3ExceptionParseFailed((Throwable)e);
                }
            }
            parser.close();
        }
        return list;
    }

    private Stream<? extends AOV3VersionData> tryToVersionData(AOV3AST.AOV3ReleaseVersionJSON version) {
        try {
            return Stream.of(AOV3ResponseParser.toVersionData(version));
        }
        catch (Exception e) {
            LOG.error("{}: error encountered during parsing version data: ", (Object)this.source, (Object)e);
            this.errorReceiver.accept(AOV3Error.builder().setContext("version").setException(e).setMessage(e.getMessage()).setSource(this.source).build());
            return Stream.empty();
        }
    }

    @Override
    public List<AOV3Release> parseAssetsForRelease() throws AOV3ExceptionParseFailed {
        List<AOV3Release> list;
        block8: {
            JsonFactory factory = this.objectMapper.getFactory();
            JsonParser parser = factory.createParser(this.stream);
            try {
                TypeReference<List<AOV3AST.AOV3ReleaseJSON>> typeReference = new TypeReference<List<AOV3AST.AOV3ReleaseJSON>>(){};
                List ast = (List)this.objectMapper.readValue(parser, (TypeReference)typeReference);
                list = ast.stream().flatMap(this::tryToRelease).collect(Collectors.toList());
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AOV3ExceptionParseFailed((Throwable)e);
                }
            }
            parser.close();
        }
        return list;
    }

    @Override
    public List<AOV3ListBinaryAssetView> parseAssetsForLatest() throws AOV3ExceptionParseFailed {
        List<AOV3ListBinaryAssetView> list;
        block8: {
            JsonFactory factory = this.objectMapper.getFactory();
            JsonParser parser = factory.createParser(this.stream);
            try {
                TypeReference<List<AOV3AST.AOV3ListBinaryAssetViewJSON>> typeReference = new TypeReference<List<AOV3AST.AOV3ListBinaryAssetViewJSON>>(){};
                List ast = (List)this.objectMapper.readValue(parser, (TypeReference)typeReference);
                list = ast.stream().flatMap(this::tryToListBinaryAssetView).collect(Collectors.toList());
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AOV3ExceptionParseFailed((Throwable)e);
                }
            }
            parser.close();
        }
        return list;
    }

    private Stream<? extends AOV3ListBinaryAssetView> tryToListBinaryAssetView(AOV3AST.AOV3ListBinaryAssetViewJSON view) {
        try {
            return Stream.of(AOV3ResponseParser.toListBinaryAssetView(view));
        }
        catch (Exception e) {
            LOG.error("exception raised during release parsing: ", (Throwable)e);
            this.errorReceiver.accept(AOV3Error.builder().setContext("release").setException(e).setMessage(e.getMessage()).setSource(this.source).build());
            return Stream.empty();
        }
    }

    private static AOV3ListBinaryAssetView toListBinaryAssetView(AOV3AST.AOV3ListBinaryAssetViewJSON view) {
        AOV3ListBinaryAssetView.Builder builder = AOV3ListBinaryAssetView.builder();
        builder.setBinary(AOV3ResponseParser.toBinary(Objects.requireNonNull(view.binary, "view.binary")));
        builder.setReleaseName(Objects.requireNonNull(view.releaseName, "view.releaseName"));
        return builder.build();
    }

    private Stream<? extends AOV3Release> tryToRelease(AOV3AST.AOV3ReleaseJSON release) {
        try {
            return Stream.of(this.toRelease(release));
        }
        catch (Exception e) {
            LOG.error("exception raised during release parsing: ", (Throwable)e);
            this.errorReceiver.accept(AOV3Error.builder().setContext("release").setException(e).setMessage(e.getMessage()).setSource(this.source).build());
            return Stream.empty();
        }
    }
}

