/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.vanilla.internal;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AOV3Deserializers
extends SimpleDeserializers {
    private static final Logger LOG = LoggerFactory.getLogger(AOV3Deserializers.class);
    private final Set<String> whitelist;

    private AOV3Deserializers(Set<String> inWhitelist) {
        this.whitelist = Objects.requireNonNull(inWhitelist, "whitelist");
    }

    private static Set<String> classWhitelist() {
        return Set.of("java.lang.String", "java.math.BigInteger", "java.net.URI", "java.util.List<java.lang.String>", "java.util.List<java.math.BigInteger>", "java.util.List<net.adoptopenjdk.v3.vanilla.internal.AOV3AST$AOV3BinaryJSON>", "java.util.List<net.adoptopenjdk.v3.vanilla.internal.AOV3AST$AOV3ListBinaryAssetViewJSON>", "java.util.List<net.adoptopenjdk.v3.vanilla.internal.AOV3AST$AOV3ReleaseJSON>", "java.util.List<net.adoptopenjdk.v3.vanilla.internal.AOV3AST$AOV3ReleaseVersionJSON>", "net.adoptopenjdk.v3.vanilla.internal.AOV3AST.AOV3AvailableReleasesJSON", "net.adoptopenjdk.v3.vanilla.internal.AOV3AST.AOV3BinaryJSON", "net.adoptopenjdk.v3.vanilla.internal.AOV3AST.AOV3InstallerJSON", "net.adoptopenjdk.v3.vanilla.internal.AOV3AST.AOV3ListBinaryAssetViewJSON", "net.adoptopenjdk.v3.vanilla.internal.AOV3AST.AOV3PackageJSON", "net.adoptopenjdk.v3.vanilla.internal.AOV3AST.AOV3ReleaseJSON", "net.adoptopenjdk.v3.vanilla.internal.AOV3AST.AOV3ReleaseNamesJSON", "net.adoptopenjdk.v3.vanilla.internal.AOV3AST.AOV3ReleaseVersionJSON", "net.adoptopenjdk.v3.vanilla.internal.AOV3AST.AOV3ReleaseVersionsJSON", "net.adoptopenjdk.v3.vanilla.internal.AOV3AST.AOV3SourceJSON");
    }

    public static AOV3Deserializers create() {
        Set<String> whiteList = AOV3Deserializers.classWhitelist();
        for (String entry : whiteList) {
            LOG.trace("whitelist: {}", (Object)entry);
        }
        return new AOV3Deserializers(whiteList);
    }

    public JsonDeserializer<?> findArrayDeserializer(ArrayType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        this.checkWhitelist(type.toCanonical());
        return super.findArrayDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
    }

    private void checkWhitelist(String name) {
        LOG.trace("checkWhitelist: {}", (Object)name);
        if (!this.whitelist.contains(name)) {
            throw new IllegalArgumentException(String.format("Deserializing a value of type %s is not allowed", name));
        }
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        this.checkWhitelist(type.getRawClass().getCanonicalName());
        return super.findBeanDeserializer(type, config, beanDesc);
    }

    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        this.checkWhitelist(type.toCanonical());
        return super.findCollectionDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
    }

    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        this.checkWhitelist(type.toCanonical());
        return super.findCollectionLikeDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
    }

    public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        this.checkWhitelist(type.getCanonicalName());
        return super.findEnumDeserializer(type, config, beanDesc);
    }

    public JsonDeserializer<?> findTreeNodeDeserializer(Class<? extends JsonNode> nodeType, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        this.checkWhitelist(nodeType.getCanonicalName());
        return super.findTreeNodeDeserializer(nodeType, config, beanDesc);
    }

    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) throws JsonMappingException {
        this.checkWhitelist(refType.toCanonical());
        return super.findReferenceDeserializer(refType, config, beanDesc, contentTypeDeserializer, contentDeserializer);
    }

    public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        this.checkWhitelist(type.toCanonical());
        return super.findMapDeserializer(type, config, beanDesc, keyDeserializer, elementTypeDeserializer, elementDeserializer);
    }

    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        this.checkWhitelist(type.toCanonical());
        return super.findMapLikeDeserializer(type, config, beanDesc, keyDeserializer, elementTypeDeserializer, elementDeserializer);
    }
}

