/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.vanilla;

import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.adoptopenjdk.v3.api.AOV3Error;
import net.adoptopenjdk.v3.api.AOV3Exception;
import net.adoptopenjdk.v3.api.AOV3ReleaseKind;
import net.adoptopenjdk.v3.api.AOV3RequestReleaseNamesType;
import net.adoptopenjdk.v3.api.AOV3SortOrder;
import net.adoptopenjdk.v3.api.AOV3Vendor;
import net.adoptopenjdk.v3.api.AOV3VersionRange;
import net.adoptopenjdk.v3.vanilla.AOV3ClientInternalType;

final class AOV3RequestReleaseNames
implements AOV3RequestReleaseNamesType {
    private final AOV3ClientInternalType client;
    private final Consumer<AOV3Error> errorReceiver;
    private final BigInteger page;
    private final BigInteger pageSize;
    private final Optional<AOV3ReleaseKind> releaseKind;
    private final Optional<AOV3SortOrder> sortOrder;
    private final Optional<AOV3Vendor> vendor;
    private final Optional<AOV3VersionRange> versionRange;

    AOV3RequestReleaseNames(AOV3ClientInternalType inClient, Consumer<AOV3Error> inErrorReceiver, BigInteger inPage, BigInteger inPageSize, Optional<AOV3ReleaseKind> inReleaseKind, Optional<AOV3SortOrder> inSortOrder, Optional<AOV3Vendor> inVendor, Optional<AOV3VersionRange> inVersionRange) {
        this.client = Objects.requireNonNull(inClient, "client");
        this.errorReceiver = Objects.requireNonNull(inErrorReceiver, "errorReceiver");
        this.page = Objects.requireNonNull(inPage, "page");
        this.pageSize = Objects.requireNonNull(inPageSize, "pageSize");
        this.releaseKind = Objects.requireNonNull(inReleaseKind, "releaseKind");
        this.sortOrder = Objects.requireNonNull(inSortOrder, "sortOrder");
        this.vendor = Objects.requireNonNull(inVendor, "vendor");
        this.versionRange = Objects.requireNonNull(inVersionRange, "versionRange");
    }

    public List<String> execute() throws AOV3Exception, InterruptedException {
        StringBuilder uriBuilder = new StringBuilder(128);
        uriBuilder.append(this.client.baseURI());
        uriBuilder.append("/info/release_names?");
        uriBuilder.append("page=");
        uriBuilder.append(this.page);
        uriBuilder.append("&page_size=");
        uriBuilder.append(this.pageSize);
        this.releaseKind.ifPresent(kind -> {
            uriBuilder.append("&release_type=");
            uriBuilder.append(kind.nameText());
        });
        this.sortOrder.ifPresent(kind -> {
            uriBuilder.append("&sort_order=");
            uriBuilder.append(kind.nameText());
        });
        this.vendor.ifPresent(kind -> {
            uriBuilder.append("&vendor=");
            uriBuilder.append(kind.nameText());
        });
        this.versionRange.ifPresent(version -> {
            uriBuilder.append("&version=");
            uriBuilder.append(URLEncoder.encode(version.toText(), StandardCharsets.UTF_8));
        });
        return this.client.parserFor(this.errorReceiver, uriBuilder.toString()).parseReleaseNames();
    }
}

