/*
 * Copyright © 2020 Mark Raynsford <code@io7m.com> http://io7m.com
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

package net.adoptopenjdk.v3.vanilla;

import net.adoptopenjdk.v3.api.AOV3Error;
import net.adoptopenjdk.v3.api.AOV3Exception;
import net.adoptopenjdk.v3.api.AOV3JVMImplementation;
import net.adoptopenjdk.v3.api.AOV3ListBinaryAssetView;
import net.adoptopenjdk.v3.api.AOV3Release;
import net.adoptopenjdk.v3.api.AOV3RequestAssetsForLatestType;
import net.adoptopenjdk.v3.api.AOV3RequestAssetsForReleaseType;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class AOV3RequestAssetsForLatest
  implements AOV3RequestAssetsForLatestType
{
  private final AOV3ClientInternalType client;
  private final AOV3JVMImplementation jvmImplementation;
  private final BigInteger version;
  private final Consumer<AOV3Error> errorReceiver;

  AOV3RequestAssetsForLatest(
    final AOV3ClientInternalType inClient,
    final Consumer<AOV3Error> inErrorReceiver,
    final BigInteger inVersion,
    final AOV3JVMImplementation inJvmImplementation)
  {
    this.client =
      Objects.requireNonNull(inClient, "inClient");
    this.errorReceiver =
      Objects.requireNonNull(inErrorReceiver, "errorReceiver");
    this.version =
      Objects.requireNonNull(inVersion, "version");
    this.jvmImplementation =
      Objects.requireNonNull(inJvmImplementation, "jvmImplementation");
  }

  @Override
  public List<AOV3ListBinaryAssetView> execute()
    throws AOV3Exception, InterruptedException
  {
    final var uriBuilder = new StringBuilder(128);
    uriBuilder.append(this.client.baseURI());
    uriBuilder.append("/assets/latest/");
    uriBuilder.append(this.version);
    uriBuilder.append("/");
    uriBuilder.append(this.jvmImplementation.nameText());

    return this.client.parserFor(this.errorReceiver, uriBuilder.toString())
      .parseAssetsForLatest();
  }
}
