/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.vanilla;

import java.net.http.HttpClient;
import java.util.Objects;
import java.util.function.Supplier;
import net.adoptopenjdk.v3.api.AOV3ClientProviderType;
import net.adoptopenjdk.v3.api.AOV3ClientType;
import net.adoptopenjdk.v3.vanilla.AOV3Client;
import net.adoptopenjdk.v3.vanilla.AOV3Messages;
import net.adoptopenjdk.v3.vanilla.AOV3MessagesType;
import net.adoptopenjdk.v3.vanilla.AOV3ResponseParsers;
import net.adoptopenjdk.v3.vanilla.AOV3ResponseParsersType;
import org.osgi.service.component.annotations.Component;

@Component(service={AOV3ClientProviderType.class})
public final class AOV3Clients
implements AOV3ClientProviderType {
    private final Supplier<HttpClient> clients;
    private final AOV3ResponseParsersType parsers;
    private final AOV3MessagesType messages;

    public AOV3Clients(AOV3ResponseParsersType inParsers, AOV3MessagesType inMessages, Supplier<HttpClient> inClients) {
        this.parsers = Objects.requireNonNull(inParsers, "parsers");
        this.messages = Objects.requireNonNull(inMessages, "messages");
        this.clients = Objects.requireNonNull(inClients, "client");
    }

    public AOV3Clients() {
        this(AOV3ResponseParsers.create(), AOV3Messages.of(AOV3Messages.getResourceBundle()), AOV3Clients::newHttpClient);
    }

    private static HttpClient newHttpClient() {
        return HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
    }

    public AOV3ClientType createClient() {
        return new AOV3Client("https://api.adoptopenjdk.net/v3", this.clients.get(), this.messages, this.parsers);
    }
}

