/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.vanilla;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import net.adoptopenjdk.v3.api.AOV3Architecture;
import net.adoptopenjdk.v3.api.AOV3ClientType;
import net.adoptopenjdk.v3.api.AOV3Error;
import net.adoptopenjdk.v3.api.AOV3Exception;
import net.adoptopenjdk.v3.api.AOV3ExceptionHTTPRequestFailed;
import net.adoptopenjdk.v3.api.AOV3ExceptionHTTPRequestIOFailed;
import net.adoptopenjdk.v3.api.AOV3HeapSize;
import net.adoptopenjdk.v3.api.AOV3ImageKind;
import net.adoptopenjdk.v3.api.AOV3JVMImplementation;
import net.adoptopenjdk.v3.api.AOV3OperatingSystem;
import net.adoptopenjdk.v3.api.AOV3ReleaseKind;
import net.adoptopenjdk.v3.api.AOV3RequestAssetsForLatestType;
import net.adoptopenjdk.v3.api.AOV3RequestAssetsForReleaseType;
import net.adoptopenjdk.v3.api.AOV3RequestBinaryForLatestType;
import net.adoptopenjdk.v3.api.AOV3RequestBinaryForReleaseType;
import net.adoptopenjdk.v3.api.AOV3RequestReleaseNamesType;
import net.adoptopenjdk.v3.api.AOV3RequestReleaseVersionsType;
import net.adoptopenjdk.v3.api.AOV3RequestReleasesType;
import net.adoptopenjdk.v3.api.AOV3SortOrder;
import net.adoptopenjdk.v3.api.AOV3Vendor;
import net.adoptopenjdk.v3.api.AOV3VersionRange;
import net.adoptopenjdk.v3.vanilla.AOV3ClientInternalType;
import net.adoptopenjdk.v3.vanilla.AOV3MessagesType;
import net.adoptopenjdk.v3.vanilla.AOV3RequestAssetsForLatest;
import net.adoptopenjdk.v3.vanilla.AOV3RequestAssetsForRelease;
import net.adoptopenjdk.v3.vanilla.AOV3RequestBinaryForLatest;
import net.adoptopenjdk.v3.vanilla.AOV3RequestBinaryForRelease;
import net.adoptopenjdk.v3.vanilla.AOV3RequestReleaseNames;
import net.adoptopenjdk.v3.vanilla.AOV3RequestReleaseVersions;
import net.adoptopenjdk.v3.vanilla.AOV3RequestReleases;
import net.adoptopenjdk.v3.vanilla.AOV3ResponseParserType;
import net.adoptopenjdk.v3.vanilla.AOV3ResponseParsersType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AOV3Client
implements AOV3ClientType,
AOV3ClientInternalType {
    private static final Logger LOG = LoggerFactory.getLogger(AOV3Client.class);
    private final String baseURI;
    private final HttpClient client;
    private final AOV3ResponseParsersType parsers;
    private final AOV3MessagesType messages;

    AOV3Client(String inBaseURI, HttpClient inClient, AOV3MessagesType inMessages, AOV3ResponseParsersType inParsers) {
        this.baseURI = Objects.requireNonNull(inBaseURI, "baseURI");
        this.client = Objects.requireNonNull(inClient, "client");
        this.messages = Objects.requireNonNull(inMessages, "messages");
        this.parsers = Objects.requireNonNull(inParsers, "parsers");
        AOV3Client.checkClientNoRedirects(this.messages, inClient);
    }

    private static void checkClientNoRedirects(AOV3MessagesType messages, HttpClient inClient) {
        switch (inClient.followRedirects()) {
            case NEVER: {
                break;
            }
            case ALWAYS: 
            case NORMAL: {
                throw new IllegalStateException(messages.httpClientNoRedirects(inClient.followRedirects()));
            }
        }
    }

    private static void logReceivedHeaders(HttpResponse<?> response) {
        if (LOG.isDebugEnabled()) {
            Map<String, List<String>> headers = response.headers().map();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String value : entry.getValue()) {
                    LOG.debug("\u2190 {}: {}", (Object)entry.getKey(), (Object)value);
                }
            }
        }
    }

    private static void logRequestHeaders(HttpHeaders request) {
        if (LOG.isDebugEnabled()) {
            Map<String, List<String>> headers = request.map();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String value : entry.getValue()) {
                    LOG.debug("\u2192 {}: {}", (Object)entry.getKey(), (Object)value);
                }
            }
        }
    }

    private static String userAgentHeader() {
        Package clazzPackage = AOV3Client.class.getPackage();
        String packageInfo = Optional.ofNullable(clazzPackage.getImplementationVersion()).orElse("0.0.0");
        return String.format("net.adoptopenjdk.v3.vanilla %s", packageInfo);
    }

    private static InputStream streamOf(HttpResponse<InputStream> response) throws IOException {
        String encoding = response.headers().firstValue("Content-Encoding").orElse("");
        if (encoding.contains("gzip")) {
            return new GZIPInputStream(response.body());
        }
        return response.body();
    }

    public void close() {
    }

    public AOV3RequestReleasesType availableReleases(Consumer<AOV3Error> errorReceiver) {
        return new AOV3RequestReleases(errorReceiver, this);
    }

    public AOV3RequestReleaseNamesType releaseNames(Consumer<AOV3Error> errorReceiver, BigInteger page, BigInteger pageSize, Optional<AOV3ReleaseKind> releaseKind, Optional<AOV3SortOrder> sortOrder, Optional<AOV3Vendor> vendor, Optional<AOV3VersionRange> versionRange) {
        return new AOV3RequestReleaseNames(this, errorReceiver, page, pageSize, releaseKind, sortOrder, vendor, versionRange);
    }

    public AOV3RequestReleaseVersionsType releaseVersions(Consumer<AOV3Error> errorReceiver, BigInteger page, BigInteger pageSize, Optional<AOV3ReleaseKind> releaseKind, Optional<AOV3SortOrder> sortOrder, Optional<AOV3Vendor> vendor, Optional<AOV3VersionRange> versionRange) {
        return new AOV3RequestReleaseVersions(this, errorReceiver, page, pageSize, releaseKind, sortOrder, vendor, versionRange);
    }

    public AOV3RequestAssetsForReleaseType assetsForRelease(Consumer<AOV3Error> errorReceiver, BigInteger page, BigInteger pageSize, BigInteger version, AOV3ReleaseKind releaseKind, Optional<AOV3Architecture> architecture, Optional<AOV3HeapSize> heapSize, Optional<AOV3ImageKind> imageKind, Optional<AOV3JVMImplementation> jvmImplementation, Optional<AOV3OperatingSystem> operatingSystem, Optional<String> project, Optional<AOV3SortOrder> sortOrder, Optional<AOV3Vendor> vendor) {
        return new AOV3RequestAssetsForRelease(this, errorReceiver, page, pageSize, version, releaseKind, architecture, heapSize, imageKind, jvmImplementation, operatingSystem, project, sortOrder, vendor);
    }

    public AOV3RequestAssetsForLatestType assetsForLatest(Consumer<AOV3Error> errorReceiver, BigInteger version, AOV3JVMImplementation jvmImplementation) {
        return new AOV3RequestAssetsForLatest(this, errorReceiver, version, jvmImplementation);
    }

    public AOV3RequestBinaryForLatestType binaryForLatest(Consumer<AOV3Error> errorReceiver, AOV3Architecture architecture, BigInteger version, AOV3HeapSize heapSize, AOV3ImageKind imageKind, AOV3JVMImplementation jvmImplementation, AOV3OperatingSystem operatingSystem, AOV3ReleaseKind releaseKind, AOV3Vendor vendor, Optional<String> project) {
        return new AOV3RequestBinaryForLatest(this, architecture, version, heapSize, imageKind, jvmImplementation, operatingSystem, releaseKind, vendor, project);
    }

    public AOV3RequestBinaryForReleaseType binaryForRelease(Consumer<AOV3Error> errorReceiver, String releaseName, AOV3OperatingSystem operatingSystem, AOV3Architecture architecture, AOV3ImageKind imageKind, AOV3JVMImplementation jvmImplementation, AOV3HeapSize heapSize, AOV3Vendor vendor, Optional<String> project) {
        return new AOV3RequestBinaryForRelease(this, architecture, heapSize, imageKind, jvmImplementation, operatingSystem, vendor, project, releaseName);
    }

    @Override
    public AOV3ResponseParserType parserForURI(Consumer<AOV3Error> errorReceiver, URI sourceURI) throws AOV3Exception, InterruptedException {
        Objects.requireNonNull(errorReceiver, "errorReceiver");
        Objects.requireNonNull(sourceURI, "sourceURI");
        try {
            HttpResponse<InputStream> response = this.send(sourceURI);
            return this.parsers.createParser(errorReceiver, response.uri(), AOV3Client.streamOf(response));
        }
        catch (IOException e) {
            throw new AOV3ExceptionHTTPRequestIOFailed(sourceURI, (Throwable)e);
        }
    }

    public URI uriFor(String uri) throws InterruptedException, AOV3ExceptionHTTPRequestIOFailed, AOV3ExceptionHTTPRequestFailed {
        HttpResponse<Void> response;
        LOG.info("GET {}", (Object)uri);
        URI sourceURI = URI.create(uri);
        HttpRequest request = HttpRequest.newBuilder(sourceURI).header("Accept-Encoding", "gzip").header("User-Agent", AOV3Client.userAgentHeader()).GET().build();
        AOV3Client.logRequestHeaders(request.headers());
        try {
            response = this.client.send(request, HttpResponse.BodyHandlers.discarding());
        }
        catch (IOException e) {
            throw new AOV3ExceptionHTTPRequestIOFailed(sourceURI, (Throwable)e);
        }
        AOV3Client.logReceivedHeaders(response);
        if (response.statusCode() == 307) {
            Optional<String> location = response.headers().firstValue("Location");
            if (location.isEmpty()) {
                throw new AOV3ExceptionHTTPRequestFailed(response.statusCode(), response.uri(), this.messages.locationMissing(response.statusCode(), response.uri()), response.headers().map());
            }
            return URI.create(location.get());
        }
        throw new AOV3ExceptionHTTPRequestFailed(response.statusCode(), response.uri(), this.messages.requestFailed(response.statusCode(), response.uri()), response.headers().map());
    }

    private HttpResponse<InputStream> send(URI sourceURI) throws InterruptedException, AOV3ExceptionHTTPRequestFailed, AOV3ExceptionHTTPRequestIOFailed {
        HttpResponse<InputStream> response;
        LOG.info("GET {}", (Object)sourceURI);
        HttpRequest request = HttpRequest.newBuilder(sourceURI).header("Accept-Encoding", "gzip").header("User-Agent", AOV3Client.userAgentHeader()).GET().build();
        AOV3Client.logRequestHeaders(request.headers());
        try {
            response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (IOException e) {
            throw new AOV3ExceptionHTTPRequestIOFailed(sourceURI, (Throwable)e);
        }
        AOV3Client.logReceivedHeaders(response);
        if (response.statusCode() >= 400) {
            throw new AOV3ExceptionHTTPRequestFailed(response.statusCode(), response.uri(), this.messages.requestFailed(response.statusCode(), response.uri()), response.headers().map());
        }
        return response;
    }

    @Override
    public String baseURI() {
        return this.baseURI;
    }
}

