/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.tests;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.adoptopenjdk.v3.api.AOV3AvailableReleases;
import net.adoptopenjdk.v3.api.AOV3BinaryType;
import net.adoptopenjdk.v3.api.AOV3Error;
import net.adoptopenjdk.v3.api.AOV3ExceptionParseFailed;
import net.adoptopenjdk.v3.api.AOV3Installer;
import net.adoptopenjdk.v3.api.AOV3ListBinaryAssetView;
import net.adoptopenjdk.v3.api.AOV3Release;
import net.adoptopenjdk.v3.tests.AOV3Fuzzing;
import net.adoptopenjdk.v3.vanilla.internal.AOV3ResponseParserType;
import net.adoptopenjdk.v3.vanilla.internal.AOV3ResponseParsers;
import net.adoptopenjdk.v3.vanilla.internal.AOV3ResponseParsersType;
import org.apache.commons.io.input.BrokenInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AOV3ResponseParsersTest {
    private static final Logger LOG = LoggerFactory.getLogger(AOV3ResponseParsersTest.class);
    private AOV3ResponseParsersType parsers;
    private ArrayList<AOV3Error> errors;

    @BeforeEach
    public void testSetup() {
        this.parsers = AOV3ResponseParsers.create();
        this.errors = new ArrayList();
    }

    private void logError(AOV3Error error) {
        LOG.error("error: {}", (Object)error);
        this.errors.add(error);
    }

    @Test
    public void testAvailableReleases() throws Exception {
        InputStream stream = AOV3ResponseParsersTest.resource("availableReleases.json");
        AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), stream);
        AOV3AvailableReleases releases = parser.parseAvailableReleases();
        Assertions.assertEquals(List.of(new BigInteger("8"), new BigInteger("11")), (Object)releases.availableLTSReleases());
        Assertions.assertEquals(List.of(new BigInteger("8"), new BigInteger("9"), new BigInteger("10"), new BigInteger("11"), new BigInteger("12"), new BigInteger("13"), new BigInteger("14")), (Object)releases.availableReleases());
        Assertions.assertEquals((Object)new BigInteger("14"), (Object)releases.mostRecentFeatureRelease());
        Assertions.assertEquals((Object)new BigInteger("11"), (Object)releases.mostRecentLTSRelease());
    }

    @Test
    public void testAvailableReleasesIOError() {
        BrokenInputStream stream = new BrokenInputStream();
        AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), (InputStream)stream);
        AOV3ExceptionParseFailed ex = (AOV3ExceptionParseFailed)Assertions.assertThrows(AOV3ExceptionParseFailed.class, () -> ((AOV3ResponseParserType)parser).parseAvailableReleases());
        Assertions.assertEquals(IOException.class, ex.getCause().getClass());
    }

    @Test
    public void testReleaseNames() throws Exception {
        InputStream stream = AOV3ResponseParsersTest.resource("releaseNames.json");
        AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), stream);
        List releases = parser.parseReleaseNames();
        Assertions.assertEquals((int)445, (int)releases.size());
        Assertions.assertTrue((boolean)releases.contains("jdk-11.0.7+7_openj9-0.20.0-m1"));
        Assertions.assertTrue((boolean)releases.contains("jdk11u-2020-03-06-09-43"));
        Assertions.assertEquals((int)0, (int)this.errors.size());
    }

    @Test
    public void testReleaseNamesIOError() {
        BrokenInputStream stream = new BrokenInputStream();
        AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), (InputStream)stream);
        AOV3ExceptionParseFailed ex = (AOV3ExceptionParseFailed)Assertions.assertThrows(AOV3ExceptionParseFailed.class, () -> ((AOV3ResponseParserType)parser).parseReleaseNames());
        Assertions.assertEquals(IOException.class, ex.getCause().getClass());
    }

    @Test
    public void testReleaseVersions() throws Exception {
        InputStream stream = AOV3ResponseParsersTest.resource("releaseVersions.json");
        AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), stream);
        List releases = parser.parseReleaseVersions();
        Assertions.assertEquals((int)0, (int)this.errors.size());
    }

    @Test
    public void testReleaseVersionsIOError() {
        BrokenInputStream stream = new BrokenInputStream();
        AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), (InputStream)stream);
        AOV3ExceptionParseFailed ex = (AOV3ExceptionParseFailed)Assertions.assertThrows(AOV3ExceptionParseFailed.class, () -> ((AOV3ResponseParserType)parser).parseReleaseVersions());
        Assertions.assertEquals(IOException.class, ex.getCause().getClass());
    }

    @Test
    public void testAssetsForRelease() throws Exception {
        InputStream stream = AOV3ResponseParsersTest.resource("assetsForRelease.json");
        AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), stream);
        List assets = parser.parseAssetsForRelease();
        AOV3Release release = (AOV3Release)assets.get(0);
        Assertions.assertEquals((Object)"MDc6UmVsZWFzZTIzMDczOTQ0", (Object)release.id());
        release = (AOV3Release)assets.get(9);
        Assertions.assertEquals((Object)"MDc6UmVsZWFzZTE5NTA2MjQ5", (Object)release.id());
        Assertions.assertEquals((int)0, (int)this.errors.size());
    }

    @Test
    public void testAssetsForReleaseIOError() {
        BrokenInputStream stream = new BrokenInputStream();
        AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), (InputStream)stream);
        AOV3ExceptionParseFailed ex = (AOV3ExceptionParseFailed)Assertions.assertThrows(AOV3ExceptionParseFailed.class, () -> ((AOV3ResponseParserType)parser).parseAssetsForRelease());
        Assertions.assertEquals(IOException.class, ex.getCause().getClass());
    }

    @Test
    public void testAssetsForReleaseBad1() throws Exception {
        InputStream stream = AOV3ResponseParsersTest.resource("assetsForReleaseBad1.json");
        AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), stream);
        parser.parseAssetsForRelease();
        Assertions.assertEquals((int)1, (int)this.errors.size());
    }

    @TestFactory
    public Stream<DynamicTest> testAssetsForReleaseFuzz() {
        return IntStream.range(1, 1000).boxed().map(index -> DynamicTest.dynamicTest((String)("testAssetsForReleaseFuzz" + index), () -> this.testAssetsForReleaseFuzzOnce((Integer)index)));
    }

    @Test
    public void testAssetsForLatest() throws Exception {
        InputStream stream = AOV3ResponseParsersTest.resource("assetsForLatest.json");
        AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), stream);
        List assets = parser.parseAssetsForLatest();
        AOV3ListBinaryAssetView release = (AOV3ListBinaryAssetView)assets.get(0);
        Assertions.assertEquals((Object)"jdk-11.0.6+10", (Object)release.releaseName());
        release = (AOV3ListBinaryAssetView)assets.get(25);
        Assertions.assertEquals((Object)"jdk-11.0.6+10", (Object)release.releaseName());
        Assertions.assertEquals((int)0, (int)this.errors.size());
    }

    @Test
    public void testAssetsForReleases8() throws Exception {
        InputStream stream = AOV3ResponseParsersTest.resource("releases8.json");
        AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), stream);
        List releases = parser.parseAssetsForRelease();
        for (AOV3Release release : releases) {
            LOG.debug("release {}", (Object)release.id());
            for (AOV3BinaryType binary : release.binaries()) {
                Optional instChecksumOpt;
                LOG.debug("release {} binary {}", (Object)release.id(), (Object)binary.package_().name());
                Optional packChecksumOpt = binary.package_().checksum();
                if (packChecksumOpt.isPresent()) {
                    String checksum = (String)packChecksumOpt.get();
                    Assertions.assertFalse((boolean)checksum.isBlank());
                }
                if (!(instChecksumOpt = binary.installer().flatMap(AOV3Installer::checksum)).isPresent()) continue;
                String checksum = (String)instChecksumOpt.get();
                Assertions.assertFalse((boolean)checksum.isBlank());
            }
        }
        Assertions.assertEquals((int)0, (int)this.errors.size());
    }

    private void testAssetsForReleaseFuzzOnce(Integer index) throws Exception {
        Random rng = new Random(index.longValue());
        try (InputStream stream = AOV3Fuzzing.filterRemoveNodes(rng, AOV3ResponseParsersTest.resource("assetsForRelease.json"), 0.001);){
            AOV3ResponseParserType parser = this.parsers.createParser(this::logError, URI.create("urn:test"), stream);
            parser.parseAssetsForRelease();
            Assertions.assertTrue((this.errors.size() > 0 ? 1 : 0) != 0);
        }
    }

    private static InputStream resource(String name) throws IOException {
        String path = String.format("/net/adoptopenjdk/v3/tests/%s", name);
        URL url = AOV3ResponseParsersTest.class.getResource(path);
        if (url == null) {
            throw new FileNotFoundException(path);
        }
        return url.openStream();
    }
}

