/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.tests;

import java.math.BigInteger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import net.adoptopenjdk.v3.api.AOV3ClientProviderType;
import net.adoptopenjdk.v3.api.AOV3ClientType;
import net.adoptopenjdk.v3.api.AOV3Error;
import net.adoptopenjdk.v3.api.AOV3ExceptionHTTPRequestFailed;
import net.adoptopenjdk.v3.api.AOV3ReleaseKind;
import net.adoptopenjdk.v3.vanilla.AOV3Clients;
import net.adoptopenjdk.v3.vanilla.internal.AOV3Messages;
import net.adoptopenjdk.v3.vanilla.internal.AOV3MessagesType;
import net.adoptopenjdk.v3.vanilla.internal.AOV3ResponseParserType;
import net.adoptopenjdk.v3.vanilla.internal.AOV3ResponseParsersType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AOV3ClientsTest {
    private static final Logger LOG = LoggerFactory.getLogger(AOV3ClientsTest.class);
    private HttpClient client;
    private AOV3ResponseParsersType parsers;
    private AOV3MessagesType messages;
    private ArrayList<AOV3Error> errors;
    private HttpResponse<Object> response;
    private AOV3ResponseParserType parser;

    @BeforeEach
    public void testSetup() {
        this.client = (HttpClient)Mockito.mock(HttpClient.class);
        this.parsers = (AOV3ResponseParsersType)Mockito.mock(AOV3ResponseParsersType.class);
        this.parser = (AOV3ResponseParserType)Mockito.mock(AOV3ResponseParserType.class);
        this.messages = AOV3Messages.of((ResourceBundle)AOV3Messages.getResourceBundle());
        this.errors = new ArrayList();
        this.response = (HttpResponse)Mockito.mock(HttpResponse.class);
    }

    private void logError(AOV3Error error) {
        LOG.error("error: {}", (Object)error);
        this.errors.add(error);
    }

    @Test
    public void testRequestFailure0() throws Exception {
        AOV3Clients clients = new AOV3Clients(this.parsers, this.messages, () -> this.client);
        HttpHeaders headers = HttpHeaders.of(Map.of(), (key, val) -> true);
        Mockito.when((Object)((Object)this.client.followRedirects())).thenReturn((Object)HttpClient.Redirect.NEVER);
        Mockito.when(this.client.send((HttpRequest)Mockito.any(), (HttpResponse.BodyHandler)Mockito.any())).thenReturn(this.response);
        Mockito.when((Object)this.response.statusCode()).thenReturn((Object)500);
        Mockito.when((Object)this.response.headers()).thenReturn((Object)headers);
        Mockito.when((Object)this.response.uri()).thenReturn((Object)URI.create("urn:test"));
        try (AOV3ClientType client = clients.createClient();){
            AOV3ExceptionHTTPRequestFailed exception = (AOV3ExceptionHTTPRequestFailed)Assertions.assertThrows(AOV3ExceptionHTTPRequestFailed.class, () -> client.assetsForRelease(this::logError, BigInteger.ZERO, BigInteger.TEN, BigInteger.valueOf(11L), AOV3ReleaseKind.GENERAL_AVAILABILITY, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()).execute());
            Assertions.assertEquals((int)500, (int)exception.statusCode());
            Assertions.assertEquals((Object)"urn:test", (Object)exception.uri().toString());
        }
    }

    @Test
    public void testService() throws Exception {
        AOV3ClientProviderType clients = ServiceLoader.load(AOV3ClientProviderType.class).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No implementations of %s are available", AOV3ClientProviderType.class)));
    }
}

