/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.tests;

import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.adoptopenjdk.v3.api.AOV3Architecture;
import net.adoptopenjdk.v3.api.AOV3ClientType;
import net.adoptopenjdk.v3.api.AOV3Error;
import net.adoptopenjdk.v3.api.AOV3HeapSize;
import net.adoptopenjdk.v3.api.AOV3ImageKind;
import net.adoptopenjdk.v3.api.AOV3JVMImplementation;
import net.adoptopenjdk.v3.api.AOV3OperatingSystem;
import net.adoptopenjdk.v3.api.AOV3ReleaseKind;
import net.adoptopenjdk.v3.api.AOV3RequestAssetsForLatestType;
import net.adoptopenjdk.v3.api.AOV3RequestAssetsForReleaseType;
import net.adoptopenjdk.v3.api.AOV3RequestBinaryForLatestType;
import net.adoptopenjdk.v3.api.AOV3RequestBinaryForReleaseType;
import net.adoptopenjdk.v3.api.AOV3RequestReleaseNamesType;
import net.adoptopenjdk.v3.api.AOV3RequestReleaseVersionsType;
import net.adoptopenjdk.v3.api.AOV3RequestReleasesType;
import net.adoptopenjdk.v3.api.AOV3SortOrder;
import net.adoptopenjdk.v3.api.AOV3Vendor;
import net.adoptopenjdk.v3.api.AOV3VersionBound;
import net.adoptopenjdk.v3.api.AOV3VersionRange;
import net.adoptopenjdk.v3.vanilla.AOV3Clients;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AOV3ClientsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(AOV3ClientsIntegrationTest.class);
    private AOV3Clients clients;
    private ArrayList<AOV3Error> errors;

    @BeforeEach
    public void testSetup() {
        this.clients = new AOV3Clients();
        this.errors = new ArrayList();
    }

    private void logError(AOV3Error error) {
        LOG.error("error: {}", (Object)error);
        this.errors.add(error);
    }

    @Test
    public void testAvailableReleases() throws Exception {
        try (AOV3ClientType client = this.clients.createClient();){
            AOV3RequestReleasesType request = client.availableReleases(this::logError);
            LOG.debug("releases: {}", request.execute());
        }
    }

    @Test
    public void testReleaseNames() throws Exception {
        try (AOV3ClientType client = this.clients.createClient();){
            AOV3RequestReleaseNamesType request = client.releaseNames(this::logError, BigInteger.ZERO, BigInteger.TEN, Optional.of(AOV3ReleaseKind.GENERAL_AVAILABILITY), Optional.of(AOV3SortOrder.ASCENDING), Optional.of(AOV3Vendor.ADOPT_OPENJDK), Optional.of(AOV3VersionRange.of((AOV3VersionBound)AOV3VersionBound.of(Optional.of("11"), (boolean)false), (AOV3VersionBound)AOV3VersionBound.of(Optional.of("12"), (boolean)true))));
            List releases = (List)request.execute();
            LOG.debug("releases: {}", (Object)releases.size());
            LOG.debug("releases: {}", (Object)releases);
        }
    }

    @Test
    public void testReleaseVersions() throws Exception {
        try (AOV3ClientType client = this.clients.createClient();){
            AOV3RequestReleaseVersionsType request = client.releaseVersions(this::logError, BigInteger.ZERO, BigInteger.TEN, Optional.of(AOV3ReleaseKind.GENERAL_AVAILABILITY), Optional.of(AOV3SortOrder.ASCENDING), Optional.of(AOV3Vendor.ADOPT_OPENJDK), Optional.of(AOV3VersionRange.of((AOV3VersionBound)AOV3VersionBound.of(Optional.of("11"), (boolean)false), (AOV3VersionBound)AOV3VersionBound.of(Optional.of("12"), (boolean)true))));
            List releases = (List)request.execute();
            LOG.debug("releases: {}", (Object)releases.size());
            LOG.debug("releases: {}", (Object)releases);
        }
    }

    @Test
    public void testAssetsForRelease() throws Exception {
        try (AOV3ClientType client = this.clients.createClient();){
            AOV3RequestAssetsForReleaseType request = client.assetsForRelease(this::logError, BigInteger.ZERO, BigInteger.TEN, BigInteger.valueOf(11L), AOV3ReleaseKind.GENERAL_AVAILABILITY, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            List releases = (List)request.execute();
            LOG.debug("releases: {}", (Object)releases.size());
            LOG.debug("releases: {}", (Object)releases);
        }
    }

    @Test
    public void testAssetsForReleaseFiltered() throws Exception {
        try (AOV3ClientType client = this.clients.createClient();){
            AOV3RequestAssetsForReleaseType request = client.assetsForRelease(this::logError, BigInteger.ZERO, BigInteger.TEN, BigInteger.valueOf(11L), AOV3ReleaseKind.GENERAL_AVAILABILITY, Optional.of(AOV3Architecture.X64), Optional.of(AOV3HeapSize.NORMAL), Optional.of(AOV3ImageKind.JDK), Optional.of(AOV3JVMImplementation.HOTSPOT), Optional.of(AOV3OperatingSystem.LINUX), Optional.of("jdk"), Optional.of(AOV3SortOrder.DESCENDING), Optional.of(AOV3Vendor.ADOPT_OPENJDK));
            List assets = (List)request.execute();
            LOG.debug("assets: {}", (Object)assets.size());
            LOG.debug("assets: {}", (Object)assets);
        }
    }

    @Test
    public void testAssetsForLatest() throws Exception {
        try (AOV3ClientType client = this.clients.createClient();){
            AOV3RequestAssetsForLatestType request = client.assetsForLatest(this::logError, BigInteger.valueOf(11L), AOV3JVMImplementation.HOTSPOT);
            List assets = (List)request.execute();
            LOG.debug("assets: {}", (Object)assets.size());
            LOG.debug("assets: {}", (Object)assets);
        }
    }

    @Test
    public void testBinaryForLatest() throws Exception {
        try (AOV3ClientType client = this.clients.createClient();){
            AOV3RequestBinaryForLatestType request = client.binaryForLatest(this::logError, AOV3Architecture.X64, BigInteger.valueOf(11L), AOV3HeapSize.NORMAL, AOV3ImageKind.JDK, AOV3JVMImplementation.HOTSPOT, AOV3OperatingSystem.LINUX, AOV3ReleaseKind.GENERAL_AVAILABILITY, AOV3Vendor.ADOPT_OPENJDK, Optional.empty());
            URI uri = (URI)request.execute();
            LOG.debug("uri: {}", (Object)uri);
        }
    }

    @Test
    public void testBinaryForLatestWithProject() throws Exception {
        try (AOV3ClientType client = this.clients.createClient();){
            AOV3RequestBinaryForLatestType request = client.binaryForLatest(this::logError, AOV3Architecture.X64, BigInteger.valueOf(11L), AOV3HeapSize.NORMAL, AOV3ImageKind.JDK, AOV3JVMImplementation.HOTSPOT, AOV3OperatingSystem.LINUX, AOV3ReleaseKind.GENERAL_AVAILABILITY, AOV3Vendor.ADOPT_OPENJDK, Optional.of("jdk"));
            URI uri = (URI)request.execute();
            LOG.debug("uri: {}", (Object)uri);
        }
    }

    @Test
    public void testBinaryForRelease() throws Exception {
        try (AOV3ClientType client = this.clients.createClient();){
            AOV3RequestBinaryForReleaseType request = client.binaryForRelease(this::logError, "jdk-11.0.6+10", AOV3OperatingSystem.LINUX, AOV3Architecture.X64, AOV3ImageKind.JDK, AOV3JVMImplementation.HOTSPOT, AOV3HeapSize.NORMAL, AOV3Vendor.ADOPT_OPENJDK, Optional.empty());
            URI uri = (URI)request.execute();
            LOG.debug("uri: {}", (Object)uri);
        }
    }

    @Test
    public void testBinaryForReleaseWithProject() throws Exception {
        try (AOV3ClientType client = this.clients.createClient();){
            AOV3RequestBinaryForReleaseType request = client.binaryForRelease(this::logError, "jdk-11.0.6+10", AOV3OperatingSystem.LINUX, AOV3Architecture.X64, AOV3ImageKind.JDK, AOV3JVMImplementation.HOTSPOT, AOV3HeapSize.NORMAL, AOV3Vendor.ADOPT_OPENJDK, Optional.of("jdk"));
            URI uri = (URI)request.execute();
            LOG.debug("uri: {}", (Object)uri);
        }
    }
}

