package net.adoptopenjdk.v3.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @see "https://api.adoptopenjdk.net/swagger-ui/#/Assets/get_v3_assets_feature
 * _releases__feature_version___release_type_"
 */
@SuppressWarnings({"all"})
public final class AOV3ListBinaryAssetView implements AOV3ListBinaryAssetViewType {
  private final AOV3Binary binary;
  private final String releaseName;

  private AOV3ListBinaryAssetView(AOV3Binary binary, String releaseName) {
    this.binary = binary;
    this.releaseName = releaseName;
  }

  /**
   * @return Information about the binary
   */
  @Override
  public AOV3Binary binary() {
    return binary;
  }

  /**
   * @return The name of the release
   */
  @Override
  public String releaseName() {
    return releaseName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3ListBinaryAssetViewType#binary() binary} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for binary
   * @return A modified copy of the {@code this} object
   */
  public final AOV3ListBinaryAssetView withBinary(AOV3Binary value) {
    if (this.binary == value) return this;
    AOV3Binary newValue = Objects.requireNonNull(value, "binary");
    return new AOV3ListBinaryAssetView(newValue, this.releaseName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3ListBinaryAssetViewType#releaseName() releaseName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for releaseName
   * @return A modified copy of the {@code this} object
   */
  public final AOV3ListBinaryAssetView withReleaseName(String value) {
    String newValue = Objects.requireNonNull(value, "releaseName");
    if (this.releaseName.equals(newValue)) return this;
    return new AOV3ListBinaryAssetView(this.binary, newValue);
  }

  /**
   * This instance is equal to all instances of {@code AOV3ListBinaryAssetView} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AOV3ListBinaryAssetView
        && equalTo((AOV3ListBinaryAssetView) another);
  }

  private boolean equalTo(AOV3ListBinaryAssetView another) {
    return binary.equals(another.binary)
        && releaseName.equals(another.releaseName);
  }

  /**
   * Computes a hash code from attributes: {@code binary}, {@code releaseName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + binary.hashCode();
    h += (h << 5) + releaseName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AOV3ListBinaryAssetView} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AOV3ListBinaryAssetView{"
        + "binary=" + binary
        + ", releaseName=" + releaseName
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link AOV3ListBinaryAssetViewType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AOV3ListBinaryAssetView instance
   */
  public static AOV3ListBinaryAssetView copyOf(AOV3ListBinaryAssetViewType instance) {
    if (instance instanceof AOV3ListBinaryAssetView) {
      return (AOV3ListBinaryAssetView) instance;
    }
    return AOV3ListBinaryAssetView.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link AOV3ListBinaryAssetView AOV3ListBinaryAssetView}.
   * <pre>
   * AOV3ListBinaryAssetView.builder()
   *    .setBinary(net.adoptopenjdk.v3.api.AOV3Binary) // required {@link AOV3ListBinaryAssetViewType#binary() binary}
   *    .setReleaseName(String) // required {@link AOV3ListBinaryAssetViewType#releaseName() releaseName}
   *    .build();
   * </pre>
   * @return A new AOV3ListBinaryAssetView builder
   */
  public static AOV3ListBinaryAssetView.Builder builder() {
    return new AOV3ListBinaryAssetView.Builder();
  }

  /**
   * Builds instances of type {@link AOV3ListBinaryAssetView AOV3ListBinaryAssetView}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_BINARY = 0x1L;
    private static final long INIT_BIT_RELEASE_NAME = 0x2L;
    private long initBits = 0x3L;

    private AOV3Binary binary;
    private String releaseName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AOV3ListBinaryAssetViewType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AOV3ListBinaryAssetViewType instance) {
      Objects.requireNonNull(instance, "instance");
      setBinary(instance.binary());
      setReleaseName(instance.releaseName());
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3ListBinaryAssetViewType#binary() binary} attribute.
     * @param binary The value for binary 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBinary(AOV3Binary binary) {
      this.binary = Objects.requireNonNull(binary, "binary");
      initBits &= ~INIT_BIT_BINARY;
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3ListBinaryAssetViewType#releaseName() releaseName} attribute.
     * @param releaseName The value for releaseName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReleaseName(String releaseName) {
      this.releaseName = Objects.requireNonNull(releaseName, "releaseName");
      initBits &= ~INIT_BIT_RELEASE_NAME;
      return this;
    }

    /**
     * Builds a new {@link AOV3ListBinaryAssetView AOV3ListBinaryAssetView}.
     * @return An immutable instance of AOV3ListBinaryAssetView
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AOV3ListBinaryAssetView build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AOV3ListBinaryAssetView(binary, releaseName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BINARY) != 0) attributes.add("binary");
      if ((initBits & INIT_BIT_RELEASE_NAME) != 0) attributes.add("releaseName");
      return "Cannot build AOV3ListBinaryAssetView, some of required attributes are not set " + attributes;
    }
  }
}
