/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import net.adoptopenjdk.v3.api.AOV3SourceType;

public final class AOV3Source
implements AOV3SourceType {
    private final URI link;
    private final String name;
    private final BigInteger size;

    private AOV3Source(URI link, String name, BigInteger size) {
        this.link = link;
        this.name = name;
        this.size = size;
    }

    @Override
    public URI link() {
        return this.link;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public BigInteger size() {
        return this.size;
    }

    public final AOV3Source withLink(URI value) {
        if (this.link == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "link");
        return new AOV3Source(newValue, this.name, this.size);
    }

    public final AOV3Source withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new AOV3Source(this.link, newValue, this.size);
    }

    public final AOV3Source withSize(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "size");
        if (this.size.equals(newValue)) {
            return this;
        }
        return new AOV3Source(this.link, this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AOV3Source && this.equalTo((AOV3Source)another);
    }

    private boolean equalTo(AOV3Source another) {
        return this.link.equals(another.link) && this.name.equals(another.name) && this.size.equals(another.size);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.link.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.size.hashCode();
        return h;
    }

    public String toString() {
        return "AOV3Source{link=" + this.link + ", name=" + this.name + ", size=" + this.size + "}";
    }

    public static AOV3Source copyOf(AOV3SourceType instance) {
        if (instance instanceof AOV3Source) {
            return (AOV3Source)instance;
        }
        return AOV3Source.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LINK = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_SIZE = 4L;
        private long initBits = 7L;
        private URI link;
        private String name;
        private BigInteger size;

        private Builder() {
        }

        public final Builder from(AOV3SourceType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setLink(instance.link());
            this.setName(instance.name());
            this.setSize(instance.size());
            return this;
        }

        public final Builder setLink(URI link) {
            this.link = Objects.requireNonNull(link, "link");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setSize(BigInteger size) {
            this.size = Objects.requireNonNull(size, "size");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public AOV3Source build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AOV3Source(this.link, this.name, this.size);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("link");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("size");
            }
            return "Cannot build AOV3Source, some of required attributes are not set " + attributes;
        }
    }
}

