/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.util.Objects;
import net.adoptopenjdk.v3.api.AOV3HasNameTextType;

public enum AOV3ReleaseKind implements AOV3HasNameTextType
{
    EARLY_ACCESS("ea"),
    GENERAL_AVAILABILITY("ga");

    private final String nameText;

    private AOV3ReleaseKind(String name) {
        this.nameText = Objects.requireNonNull(name, "name");
    }

    public static AOV3ReleaseKind of(String kind) {
        switch (kind) {
            case "ea": {
                return EARLY_ACCESS;
            }
            case "ga": {
                return GENERAL_AVAILABILITY;
            }
        }
        throw new IllegalStateException("Unexpected value: " + kind);
    }

    @Override
    public String nameText() {
        return this.nameText;
    }
}

