/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.adoptopenjdk.v3.api.AOV3InstallerType;

public final class AOV3Installer
implements AOV3InstallerType {
    private final String checksum;
    private final URI checksumLink;
    private final BigInteger downloadCount;
    private final URI link;
    private final String name;
    private final URI signatureLink;
    private final BigInteger size;

    private AOV3Installer(String checksum, URI checksumLink, BigInteger downloadCount, URI link, String name, URI signatureLink, BigInteger size) {
        this.checksum = checksum;
        this.checksumLink = checksumLink;
        this.downloadCount = downloadCount;
        this.link = link;
        this.name = name;
        this.signatureLink = signatureLink;
        this.size = size;
    }

    @Override
    public Optional<String> checksum() {
        return Optional.ofNullable(this.checksum);
    }

    @Override
    public Optional<URI> checksumLink() {
        return Optional.ofNullable(this.checksumLink);
    }

    @Override
    public BigInteger downloadCount() {
        return this.downloadCount;
    }

    @Override
    public URI link() {
        return this.link;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<URI> signatureLink() {
        return Optional.ofNullable(this.signatureLink);
    }

    @Override
    public BigInteger size() {
        return this.size;
    }

    public final AOV3Installer withChecksum(String value) {
        String newValue = Objects.requireNonNull(value, "checksum");
        if (Objects.equals(this.checksum, newValue)) {
            return this;
        }
        return new AOV3Installer(newValue, this.checksumLink, this.downloadCount, this.link, this.name, this.signatureLink, this.size);
    }

    public final AOV3Installer withChecksum(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.checksum, value)) {
            return this;
        }
        return new AOV3Installer(value, this.checksumLink, this.downloadCount, this.link, this.name, this.signatureLink, this.size);
    }

    public final AOV3Installer withChecksumLink(URI value) {
        URI newValue = Objects.requireNonNull(value, "checksumLink");
        if (this.checksumLink == newValue) {
            return this;
        }
        return new AOV3Installer(this.checksum, newValue, this.downloadCount, this.link, this.name, this.signatureLink, this.size);
    }

    public final AOV3Installer withChecksumLink(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.checksumLink == value) {
            return this;
        }
        return new AOV3Installer(this.checksum, value, this.downloadCount, this.link, this.name, this.signatureLink, this.size);
    }

    public final AOV3Installer withDownloadCount(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "downloadCount");
        if (this.downloadCount.equals(newValue)) {
            return this;
        }
        return new AOV3Installer(this.checksum, this.checksumLink, newValue, this.link, this.name, this.signatureLink, this.size);
    }

    public final AOV3Installer withLink(URI value) {
        if (this.link == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "link");
        return new AOV3Installer(this.checksum, this.checksumLink, this.downloadCount, newValue, this.name, this.signatureLink, this.size);
    }

    public final AOV3Installer withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new AOV3Installer(this.checksum, this.checksumLink, this.downloadCount, this.link, newValue, this.signatureLink, this.size);
    }

    public final AOV3Installer withSignatureLink(URI value) {
        URI newValue = Objects.requireNonNull(value, "signatureLink");
        if (this.signatureLink == newValue) {
            return this;
        }
        return new AOV3Installer(this.checksum, this.checksumLink, this.downloadCount, this.link, this.name, newValue, this.size);
    }

    public final AOV3Installer withSignatureLink(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.signatureLink == value) {
            return this;
        }
        return new AOV3Installer(this.checksum, this.checksumLink, this.downloadCount, this.link, this.name, value, this.size);
    }

    public final AOV3Installer withSize(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "size");
        if (this.size.equals(newValue)) {
            return this;
        }
        return new AOV3Installer(this.checksum, this.checksumLink, this.downloadCount, this.link, this.name, this.signatureLink, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AOV3Installer && this.equalTo((AOV3Installer)another);
    }

    private boolean equalTo(AOV3Installer another) {
        return Objects.equals(this.checksum, another.checksum) && Objects.equals(this.checksumLink, another.checksumLink) && this.downloadCount.equals(another.downloadCount) && this.link.equals(another.link) && this.name.equals(another.name) && Objects.equals(this.signatureLink, another.signatureLink) && this.size.equals(another.size);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.checksum);
        h += (h << 5) + Objects.hashCode(this.checksumLink);
        h += (h << 5) + this.downloadCount.hashCode();
        h += (h << 5) + this.link.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.signatureLink);
        h += (h << 5) + this.size.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AOV3Installer{");
        if (this.checksum != null) {
            builder.append("checksum=").append(this.checksum);
        }
        if (this.checksumLink != null) {
            if (builder.length() > 14) {
                builder.append(", ");
            }
            builder.append("checksumLink=").append(this.checksumLink);
        }
        if (builder.length() > 14) {
            builder.append(", ");
        }
        builder.append("downloadCount=").append(this.downloadCount);
        builder.append(", ");
        builder.append("link=").append(this.link);
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.signatureLink != null) {
            builder.append(", ");
            builder.append("signatureLink=").append(this.signatureLink);
        }
        builder.append(", ");
        builder.append("size=").append(this.size);
        return builder.append("}").toString();
    }

    public static AOV3Installer copyOf(AOV3InstallerType instance) {
        if (instance instanceof AOV3Installer) {
            return (AOV3Installer)instance;
        }
        return AOV3Installer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DOWNLOAD_COUNT = 1L;
        private static final long INIT_BIT_LINK = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_SIZE = 8L;
        private long initBits = 15L;
        private String checksum;
        private URI checksumLink;
        private BigInteger downloadCount;
        private URI link;
        private String name;
        private URI signatureLink;
        private BigInteger size;

        private Builder() {
        }

        public final Builder from(AOV3InstallerType instance) {
            Optional<URI> checksumLinkOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> checksumOptional = instance.checksum();
            if (checksumOptional.isPresent()) {
                this.setChecksum(checksumOptional);
            }
            if ((checksumLinkOptional = instance.checksumLink()).isPresent()) {
                this.setChecksumLink(checksumLinkOptional);
            }
            this.setDownloadCount(instance.downloadCount());
            this.setLink(instance.link());
            this.setName(instance.name());
            Optional<URI> signatureLinkOptional = instance.signatureLink();
            if (signatureLinkOptional.isPresent()) {
                this.setSignatureLink(signatureLinkOptional);
            }
            this.setSize(instance.size());
            return this;
        }

        public final Builder setChecksum(String checksum) {
            this.checksum = Objects.requireNonNull(checksum, "checksum");
            return this;
        }

        public final Builder setChecksum(Optional<String> checksum) {
            this.checksum = checksum.orElse(null);
            return this;
        }

        public final Builder setChecksumLink(URI checksumLink) {
            this.checksumLink = Objects.requireNonNull(checksumLink, "checksumLink");
            return this;
        }

        public final Builder setChecksumLink(Optional<? extends URI> checksumLink) {
            this.checksumLink = checksumLink.orElse(null);
            return this;
        }

        public final Builder setDownloadCount(BigInteger downloadCount) {
            this.downloadCount = Objects.requireNonNull(downloadCount, "downloadCount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setLink(URI link) {
            this.link = Objects.requireNonNull(link, "link");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setSignatureLink(URI signatureLink) {
            this.signatureLink = Objects.requireNonNull(signatureLink, "signatureLink");
            return this;
        }

        public final Builder setSignatureLink(Optional<? extends URI> signatureLink) {
            this.signatureLink = signatureLink.orElse(null);
            return this;
        }

        public final Builder setSize(BigInteger size) {
            this.size = Objects.requireNonNull(size, "size");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public AOV3Installer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AOV3Installer(this.checksum, this.checksumLink, this.downloadCount, this.link, this.name, this.signatureLink, this.size);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("downloadCount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("link");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("size");
            }
            return "Cannot build AOV3Installer, some of required attributes are not set " + attributes;
        }
    }
}

