/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.adoptopenjdk.v3.api.AOV3ErrorType;

public final class AOV3Error
implements AOV3ErrorType {
    private final URI source;
    private final String context;
    private final String message;
    private final Exception exception;

    private AOV3Error(URI source, String context, String message, Exception exception) {
        this.source = source;
        this.context = context;
        this.message = message;
        this.exception = exception;
    }

    @Override
    public URI source() {
        return this.source;
    }

    @Override
    public String context() {
        return this.context;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public Optional<Exception> exception() {
        return Optional.ofNullable(this.exception);
    }

    public final AOV3Error withSource(URI value) {
        if (this.source == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "source");
        return new AOV3Error(newValue, this.context, this.message, this.exception);
    }

    public final AOV3Error withContext(String value) {
        String newValue = Objects.requireNonNull(value, "context");
        if (this.context.equals(newValue)) {
            return this;
        }
        return new AOV3Error(this.source, newValue, this.message, this.exception);
    }

    public final AOV3Error withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new AOV3Error(this.source, this.context, newValue, this.exception);
    }

    public final AOV3Error withException(Exception value) {
        Exception newValue = Objects.requireNonNull(value, "exception");
        if (this.exception == newValue) {
            return this;
        }
        return new AOV3Error(this.source, this.context, this.message, newValue);
    }

    public final AOV3Error withException(Optional<? extends Exception> optional) {
        Exception value = optional.orElse(null);
        if (this.exception == value) {
            return this;
        }
        return new AOV3Error(this.source, this.context, this.message, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AOV3Error && this.equalTo((AOV3Error)another);
    }

    private boolean equalTo(AOV3Error another) {
        return this.source.equals(another.source) && this.context.equals(another.context) && this.message.equals(another.message) && Objects.equals(this.exception, another.exception);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.context.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.exception);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AOV3Error{");
        builder.append("source=").append(this.source);
        builder.append(", ");
        builder.append("context=").append(this.context);
        builder.append(", ");
        builder.append("message=").append(this.message);
        if (this.exception != null) {
            builder.append(", ");
            builder.append("exception=").append(this.exception);
        }
        return builder.append("}").toString();
    }

    public static AOV3Error copyOf(AOV3ErrorType instance) {
        if (instance instanceof AOV3Error) {
            return (AOV3Error)instance;
        }
        return AOV3Error.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SOURCE = 1L;
        private static final long INIT_BIT_CONTEXT = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private long initBits = 7L;
        private URI source;
        private String context;
        private String message;
        private Exception exception;

        private Builder() {
        }

        public final Builder from(AOV3ErrorType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setSource(instance.source());
            this.setContext(instance.context());
            this.setMessage(instance.message());
            Optional<Exception> exceptionOptional = instance.exception();
            if (exceptionOptional.isPresent()) {
                this.setException(exceptionOptional);
            }
            return this;
        }

        public final Builder setSource(URI source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setContext(String context) {
            this.context = Objects.requireNonNull(context, "context");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setMessage(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setException(Exception exception) {
            this.exception = Objects.requireNonNull(exception, "exception");
            return this;
        }

        public final Builder setException(Optional<? extends Exception> exception) {
            this.exception = exception.orElse(null);
            return this;
        }

        public AOV3Error build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AOV3Error(this.source, this.context, this.message, this.exception);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("context");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build AOV3Error, some of required attributes are not set " + attributes;
        }
    }
}

