/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.util.Objects;
import net.adoptopenjdk.v3.api.AOV3HasNameTextType;

public enum AOV3Architecture implements AOV3HasNameTextType
{
    AARCH64("aarch64"),
    ARM("arm"),
    PPC64("ppc64"),
    PPC64LE("ppc64le"),
    S390X("s390x"),
    SPARCV9("sparcv9"),
    X32("x32"),
    X64("x64");

    private final String nameText;

    private AOV3Architecture(String name) {
        this.nameText = Objects.requireNonNull(name, "name");
    }

    public static AOV3Architecture of(String architecture) {
        return AOV3Architecture.valueOf(architecture.toUpperCase());
    }

    @Override
    public String nameText() {
        return this.nameText;
    }
}

