package net.adoptopenjdk.v3.api;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Versioning data.
 */
@SuppressWarnings({"all"})
public final class AOV3VersionData implements AOV3VersionDataType {
  private final BigInteger adoptBuildNumber;
  private final BigInteger build;
  private final BigInteger major;
  private final BigInteger minor;
  private final String openJDKVersion;
  private final String optional;
  private final String pre;
  private final BigInteger security;
  private final String semanticVersion;

  private AOV3VersionData(
      BigInteger adoptBuildNumber,
      BigInteger build,
      BigInteger major,
      BigInteger minor,
      String openJDKVersion,
      String optional,
      String pre,
      BigInteger security,
      String semanticVersion) {
    this.adoptBuildNumber = adoptBuildNumber;
    this.build = build;
    this.major = major;
    this.minor = minor;
    this.openJDKVersion = openJDKVersion;
    this.optional = optional;
    this.pre = pre;
    this.security = security;
    this.semanticVersion = semanticVersion;
  }

  /**
   * @return The AdoptOpenJDK build number
   */
  @Override
  public BigInteger adoptBuildNumber() {
    return adoptBuildNumber;
  }

  /**
   * @return The value of the {@code build} attribute
   */
  @Override
  public BigInteger build() {
    return build;
  }

  /**
   * @return The major version number
   */
  @Override
  public BigInteger major() {
    return major;
  }

  /**
   * @return The minor version number
   */
  @Override
  public BigInteger minor() {
    return minor;
  }

  /**
   * @return The value of the {@code openJDKVersion} attribute
   */
  @Override
  public String openJDKVersion() {
    return openJDKVersion;
  }

  /**
   * @return The value of the {@code optional} attribute
   */
  @Override
  public String optional() {
    return optional;
  }

  /**
   * @return The value of the {@code pre} attribute
   */
  @Override
  public String pre() {
    return pre;
  }

  /**
   * @return The value of the {@code security} attribute
   */
  @Override
  public BigInteger security() {
    return security;
  }

  /**
   * @return The semantic version number
   */
  @Override
  public String semanticVersion() {
    return semanticVersion;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3VersionDataType#adoptBuildNumber() adoptBuildNumber} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for adoptBuildNumber
   * @return A modified copy of the {@code this} object
   */
  public final AOV3VersionData withAdoptBuildNumber(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "adoptBuildNumber");
    if (this.adoptBuildNumber.equals(newValue)) return this;
    return new AOV3VersionData(
        newValue,
        this.build,
        this.major,
        this.minor,
        this.openJDKVersion,
        this.optional,
        this.pre,
        this.security,
        this.semanticVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3VersionDataType#build() build} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for build
   * @return A modified copy of the {@code this} object
   */
  public final AOV3VersionData withBuild(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "build");
    if (this.build.equals(newValue)) return this;
    return new AOV3VersionData(
        this.adoptBuildNumber,
        newValue,
        this.major,
        this.minor,
        this.openJDKVersion,
        this.optional,
        this.pre,
        this.security,
        this.semanticVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3VersionDataType#major() major} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for major
   * @return A modified copy of the {@code this} object
   */
  public final AOV3VersionData withMajor(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "major");
    if (this.major.equals(newValue)) return this;
    return new AOV3VersionData(
        this.adoptBuildNumber,
        this.build,
        newValue,
        this.minor,
        this.openJDKVersion,
        this.optional,
        this.pre,
        this.security,
        this.semanticVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3VersionDataType#minor() minor} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minor
   * @return A modified copy of the {@code this} object
   */
  public final AOV3VersionData withMinor(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "minor");
    if (this.minor.equals(newValue)) return this;
    return new AOV3VersionData(
        this.adoptBuildNumber,
        this.build,
        this.major,
        newValue,
        this.openJDKVersion,
        this.optional,
        this.pre,
        this.security,
        this.semanticVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3VersionDataType#openJDKVersion() openJDKVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for openJDKVersion
   * @return A modified copy of the {@code this} object
   */
  public final AOV3VersionData withOpenJDKVersion(String value) {
    String newValue = Objects.requireNonNull(value, "openJDKVersion");
    if (this.openJDKVersion.equals(newValue)) return this;
    return new AOV3VersionData(
        this.adoptBuildNumber,
        this.build,
        this.major,
        this.minor,
        newValue,
        this.optional,
        this.pre,
        this.security,
        this.semanticVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3VersionDataType#optional() optional} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for optional
   * @return A modified copy of the {@code this} object
   */
  public final AOV3VersionData withOptional(String value) {
    String newValue = Objects.requireNonNull(value, "optional");
    if (this.optional.equals(newValue)) return this;
    return new AOV3VersionData(
        this.adoptBuildNumber,
        this.build,
        this.major,
        this.minor,
        this.openJDKVersion,
        newValue,
        this.pre,
        this.security,
        this.semanticVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3VersionDataType#pre() pre} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pre
   * @return A modified copy of the {@code this} object
   */
  public final AOV3VersionData withPre(String value) {
    String newValue = Objects.requireNonNull(value, "pre");
    if (this.pre.equals(newValue)) return this;
    return new AOV3VersionData(
        this.adoptBuildNumber,
        this.build,
        this.major,
        this.minor,
        this.openJDKVersion,
        this.optional,
        newValue,
        this.security,
        this.semanticVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3VersionDataType#security() security} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for security
   * @return A modified copy of the {@code this} object
   */
  public final AOV3VersionData withSecurity(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "security");
    if (this.security.equals(newValue)) return this;
    return new AOV3VersionData(
        this.adoptBuildNumber,
        this.build,
        this.major,
        this.minor,
        this.openJDKVersion,
        this.optional,
        this.pre,
        newValue,
        this.semanticVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3VersionDataType#semanticVersion() semanticVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for semanticVersion
   * @return A modified copy of the {@code this} object
   */
  public final AOV3VersionData withSemanticVersion(String value) {
    String newValue = Objects.requireNonNull(value, "semanticVersion");
    if (this.semanticVersion.equals(newValue)) return this;
    return new AOV3VersionData(
        this.adoptBuildNumber,
        this.build,
        this.major,
        this.minor,
        this.openJDKVersion,
        this.optional,
        this.pre,
        this.security,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code AOV3VersionData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AOV3VersionData
        && equalTo((AOV3VersionData) another);
  }

  private boolean equalTo(AOV3VersionData another) {
    return adoptBuildNumber.equals(another.adoptBuildNumber)
        && build.equals(another.build)
        && major.equals(another.major)
        && minor.equals(another.minor)
        && openJDKVersion.equals(another.openJDKVersion)
        && optional.equals(another.optional)
        && pre.equals(another.pre)
        && security.equals(another.security)
        && semanticVersion.equals(another.semanticVersion);
  }

  /**
   * Computes a hash code from attributes: {@code adoptBuildNumber}, {@code build}, {@code major}, {@code minor}, {@code openJDKVersion}, {@code optional}, {@code pre}, {@code security}, {@code semanticVersion}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + adoptBuildNumber.hashCode();
    h += (h << 5) + build.hashCode();
    h += (h << 5) + major.hashCode();
    h += (h << 5) + minor.hashCode();
    h += (h << 5) + openJDKVersion.hashCode();
    h += (h << 5) + optional.hashCode();
    h += (h << 5) + pre.hashCode();
    h += (h << 5) + security.hashCode();
    h += (h << 5) + semanticVersion.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AOV3VersionData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AOV3VersionData{"
        + "adoptBuildNumber=" + adoptBuildNumber
        + ", build=" + build
        + ", major=" + major
        + ", minor=" + minor
        + ", openJDKVersion=" + openJDKVersion
        + ", optional=" + optional
        + ", pre=" + pre
        + ", security=" + security
        + ", semanticVersion=" + semanticVersion
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link AOV3VersionDataType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AOV3VersionData instance
   */
  public static AOV3VersionData copyOf(AOV3VersionDataType instance) {
    if (instance instanceof AOV3VersionData) {
      return (AOV3VersionData) instance;
    }
    return AOV3VersionData.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link AOV3VersionData AOV3VersionData}.
   * <pre>
   * AOV3VersionData.builder()
   *    .setAdoptBuildNumber(java.math.BigInteger) // required {@link AOV3VersionDataType#adoptBuildNumber() adoptBuildNumber}
   *    .setBuild(java.math.BigInteger) // required {@link AOV3VersionDataType#build() build}
   *    .setMajor(java.math.BigInteger) // required {@link AOV3VersionDataType#major() major}
   *    .setMinor(java.math.BigInteger) // required {@link AOV3VersionDataType#minor() minor}
   *    .setOpenJDKVersion(String) // required {@link AOV3VersionDataType#openJDKVersion() openJDKVersion}
   *    .setOptional(String) // required {@link AOV3VersionDataType#optional() optional}
   *    .setPre(String) // required {@link AOV3VersionDataType#pre() pre}
   *    .setSecurity(java.math.BigInteger) // required {@link AOV3VersionDataType#security() security}
   *    .setSemanticVersion(String) // required {@link AOV3VersionDataType#semanticVersion() semanticVersion}
   *    .build();
   * </pre>
   * @return A new AOV3VersionData builder
   */
  public static AOV3VersionData.Builder builder() {
    return new AOV3VersionData.Builder();
  }

  /**
   * Builds instances of type {@link AOV3VersionData AOV3VersionData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ADOPT_BUILD_NUMBER = 0x1L;
    private static final long INIT_BIT_BUILD = 0x2L;
    private static final long INIT_BIT_MAJOR = 0x4L;
    private static final long INIT_BIT_MINOR = 0x8L;
    private static final long INIT_BIT_OPEN_J_D_K_VERSION = 0x10L;
    private static final long INIT_BIT_OPTIONAL = 0x20L;
    private static final long INIT_BIT_PRE = 0x40L;
    private static final long INIT_BIT_SECURITY = 0x80L;
    private static final long INIT_BIT_SEMANTIC_VERSION = 0x100L;
    private long initBits = 0x1ffL;

    private BigInteger adoptBuildNumber;
    private BigInteger build;
    private BigInteger major;
    private BigInteger minor;
    private String openJDKVersion;
    private String optional;
    private String pre;
    private BigInteger security;
    private String semanticVersion;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AOV3VersionDataType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AOV3VersionDataType instance) {
      Objects.requireNonNull(instance, "instance");
      setAdoptBuildNumber(instance.adoptBuildNumber());
      setBuild(instance.build());
      setMajor(instance.major());
      setMinor(instance.minor());
      setOpenJDKVersion(instance.openJDKVersion());
      setOptional(instance.optional());
      setPre(instance.pre());
      setSecurity(instance.security());
      setSemanticVersion(instance.semanticVersion());
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3VersionDataType#adoptBuildNumber() adoptBuildNumber} attribute.
     * @param adoptBuildNumber The value for adoptBuildNumber 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAdoptBuildNumber(BigInteger adoptBuildNumber) {
      this.adoptBuildNumber = Objects.requireNonNull(adoptBuildNumber, "adoptBuildNumber");
      initBits &= ~INIT_BIT_ADOPT_BUILD_NUMBER;
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3VersionDataType#build() build} attribute.
     * @param build The value for build 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBuild(BigInteger build) {
      this.build = Objects.requireNonNull(build, "build");
      initBits &= ~INIT_BIT_BUILD;
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3VersionDataType#major() major} attribute.
     * @param major The value for major 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMajor(BigInteger major) {
      this.major = Objects.requireNonNull(major, "major");
      initBits &= ~INIT_BIT_MAJOR;
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3VersionDataType#minor() minor} attribute.
     * @param minor The value for minor 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMinor(BigInteger minor) {
      this.minor = Objects.requireNonNull(minor, "minor");
      initBits &= ~INIT_BIT_MINOR;
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3VersionDataType#openJDKVersion() openJDKVersion} attribute.
     * @param openJDKVersion The value for openJDKVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOpenJDKVersion(String openJDKVersion) {
      this.openJDKVersion = Objects.requireNonNull(openJDKVersion, "openJDKVersion");
      initBits &= ~INIT_BIT_OPEN_J_D_K_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3VersionDataType#optional() optional} attribute.
     * @param optional The value for optional 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptional(String optional) {
      this.optional = Objects.requireNonNull(optional, "optional");
      initBits &= ~INIT_BIT_OPTIONAL;
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3VersionDataType#pre() pre} attribute.
     * @param pre The value for pre 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPre(String pre) {
      this.pre = Objects.requireNonNull(pre, "pre");
      initBits &= ~INIT_BIT_PRE;
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3VersionDataType#security() security} attribute.
     * @param security The value for security 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSecurity(BigInteger security) {
      this.security = Objects.requireNonNull(security, "security");
      initBits &= ~INIT_BIT_SECURITY;
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3VersionDataType#semanticVersion() semanticVersion} attribute.
     * @param semanticVersion The value for semanticVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSemanticVersion(String semanticVersion) {
      this.semanticVersion = Objects.requireNonNull(semanticVersion, "semanticVersion");
      initBits &= ~INIT_BIT_SEMANTIC_VERSION;
      return this;
    }

    /**
     * Builds a new {@link AOV3VersionData AOV3VersionData}.
     * @return An immutable instance of AOV3VersionData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AOV3VersionData build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AOV3VersionData(
          adoptBuildNumber,
          build,
          major,
          minor,
          openJDKVersion,
          optional,
          pre,
          security,
          semanticVersion);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ADOPT_BUILD_NUMBER) != 0) attributes.add("adoptBuildNumber");
      if ((initBits & INIT_BIT_BUILD) != 0) attributes.add("build");
      if ((initBits & INIT_BIT_MAJOR) != 0) attributes.add("major");
      if ((initBits & INIT_BIT_MINOR) != 0) attributes.add("minor");
      if ((initBits & INIT_BIT_OPEN_J_D_K_VERSION) != 0) attributes.add("openJDKVersion");
      if ((initBits & INIT_BIT_OPTIONAL) != 0) attributes.add("optional");
      if ((initBits & INIT_BIT_PRE) != 0) attributes.add("pre");
      if ((initBits & INIT_BIT_SECURITY) != 0) attributes.add("security");
      if ((initBits & INIT_BIT_SEMANTIC_VERSION) != 0) attributes.add("semanticVersion");
      return "Cannot build AOV3VersionData, some of required attributes are not set " + attributes;
    }
  }
}
