package net.adoptopenjdk.v3.api;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * A set of available releases.
 */
@SuppressWarnings({"all"})
public final class AOV3AvailableReleases implements AOV3AvailableReleasesType {
  private final List<BigInteger> availableLTSReleases;
  private final List<BigInteger> availableReleases;
  private final BigInteger mostRecentFeatureRelease;
  private final BigInteger mostRecentLTSRelease;

  private AOV3AvailableReleases(
      List<BigInteger> availableLTSReleases,
      List<BigInteger> availableReleases,
      BigInteger mostRecentFeatureRelease,
      BigInteger mostRecentLTSRelease) {
    this.availableLTSReleases = availableLTSReleases;
    this.availableReleases = availableReleases;
    this.mostRecentFeatureRelease = mostRecentFeatureRelease;
    this.mostRecentLTSRelease = mostRecentLTSRelease;
  }

  /**
   * @return The version numbers of the available LTS releases
   */
  @Override
  public List<BigInteger> availableLTSReleases() {
    return availableLTSReleases;
  }

  /**
   * @return The version numbers of the available releases
   */
  @Override
  public List<BigInteger> availableReleases() {
    return availableReleases;
  }

  /**
   * @return The version number of the most recent feature release
   */
  @Override
  public BigInteger mostRecentFeatureRelease() {
    return mostRecentFeatureRelease;
  }

  /**
   * @return The version number of the most recent LTS release
   */
  @Override
  public BigInteger mostRecentLTSRelease() {
    return mostRecentLTSRelease;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AOV3AvailableReleasesType#availableLTSReleases() availableLTSReleases}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final AOV3AvailableReleases withAvailableLTSReleases(BigInteger... elements) {
    List<BigInteger> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new AOV3AvailableReleases(newValue, this.availableReleases, this.mostRecentFeatureRelease, this.mostRecentLTSRelease);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AOV3AvailableReleasesType#availableLTSReleases() availableLTSReleases}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of availableLTSReleases elements to set
   * @return A modified copy of {@code this} object
   */
  public final AOV3AvailableReleases withAvailableLTSReleases(Iterable<? extends BigInteger> elements) {
    if (this.availableLTSReleases == elements) return this;
    List<BigInteger> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new AOV3AvailableReleases(newValue, this.availableReleases, this.mostRecentFeatureRelease, this.mostRecentLTSRelease);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AOV3AvailableReleasesType#availableReleases() availableReleases}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final AOV3AvailableReleases withAvailableReleases(BigInteger... elements) {
    List<BigInteger> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new AOV3AvailableReleases(this.availableLTSReleases, newValue, this.mostRecentFeatureRelease, this.mostRecentLTSRelease);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AOV3AvailableReleasesType#availableReleases() availableReleases}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of availableReleases elements to set
   * @return A modified copy of {@code this} object
   */
  public final AOV3AvailableReleases withAvailableReleases(Iterable<? extends BigInteger> elements) {
    if (this.availableReleases == elements) return this;
    List<BigInteger> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new AOV3AvailableReleases(this.availableLTSReleases, newValue, this.mostRecentFeatureRelease, this.mostRecentLTSRelease);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3AvailableReleasesType#mostRecentFeatureRelease() mostRecentFeatureRelease} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mostRecentFeatureRelease
   * @return A modified copy of the {@code this} object
   */
  public final AOV3AvailableReleases withMostRecentFeatureRelease(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "mostRecentFeatureRelease");
    if (this.mostRecentFeatureRelease.equals(newValue)) return this;
    return new AOV3AvailableReleases(this.availableLTSReleases, this.availableReleases, newValue, this.mostRecentLTSRelease);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AOV3AvailableReleasesType#mostRecentLTSRelease() mostRecentLTSRelease} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mostRecentLTSRelease
   * @return A modified copy of the {@code this} object
   */
  public final AOV3AvailableReleases withMostRecentLTSRelease(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "mostRecentLTSRelease");
    if (this.mostRecentLTSRelease.equals(newValue)) return this;
    return new AOV3AvailableReleases(this.availableLTSReleases, this.availableReleases, this.mostRecentFeatureRelease, newValue);
  }

  /**
   * This instance is equal to all instances of {@code AOV3AvailableReleases} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AOV3AvailableReleases
        && equalTo((AOV3AvailableReleases) another);
  }

  private boolean equalTo(AOV3AvailableReleases another) {
    return availableLTSReleases.equals(another.availableLTSReleases)
        && availableReleases.equals(another.availableReleases)
        && mostRecentFeatureRelease.equals(another.mostRecentFeatureRelease)
        && mostRecentLTSRelease.equals(another.mostRecentLTSRelease);
  }

  /**
   * Computes a hash code from attributes: {@code availableLTSReleases}, {@code availableReleases}, {@code mostRecentFeatureRelease}, {@code mostRecentLTSRelease}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + availableLTSReleases.hashCode();
    h += (h << 5) + availableReleases.hashCode();
    h += (h << 5) + mostRecentFeatureRelease.hashCode();
    h += (h << 5) + mostRecentLTSRelease.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AOV3AvailableReleases} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AOV3AvailableReleases{"
        + "availableLTSReleases=" + availableLTSReleases
        + ", availableReleases=" + availableReleases
        + ", mostRecentFeatureRelease=" + mostRecentFeatureRelease
        + ", mostRecentLTSRelease=" + mostRecentLTSRelease
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link AOV3AvailableReleasesType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AOV3AvailableReleases instance
   */
  public static AOV3AvailableReleases copyOf(AOV3AvailableReleasesType instance) {
    if (instance instanceof AOV3AvailableReleases) {
      return (AOV3AvailableReleases) instance;
    }
    return AOV3AvailableReleases.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link AOV3AvailableReleases AOV3AvailableReleases}.
   * <pre>
   * AOV3AvailableReleases.builder()
   *    .addAvailableLTSReleases|addAllAvailableLTSReleases(java.math.BigInteger) // {@link AOV3AvailableReleasesType#availableLTSReleases() availableLTSReleases} elements
   *    .addAvailableReleases|addAllAvailableReleases(java.math.BigInteger) // {@link AOV3AvailableReleasesType#availableReleases() availableReleases} elements
   *    .setMostRecentFeatureRelease(java.math.BigInteger) // required {@link AOV3AvailableReleasesType#mostRecentFeatureRelease() mostRecentFeatureRelease}
   *    .setMostRecentLTSRelease(java.math.BigInteger) // required {@link AOV3AvailableReleasesType#mostRecentLTSRelease() mostRecentLTSRelease}
   *    .build();
   * </pre>
   * @return A new AOV3AvailableReleases builder
   */
  public static AOV3AvailableReleases.Builder builder() {
    return new AOV3AvailableReleases.Builder();
  }

  /**
   * Builds instances of type {@link AOV3AvailableReleases AOV3AvailableReleases}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_MOST_RECENT_FEATURE_RELEASE = 0x1L;
    private static final long INIT_BIT_MOST_RECENT_L_T_S_RELEASE = 0x2L;
    private long initBits = 0x3L;

    private List<BigInteger> availableLTSReleases = new ArrayList<BigInteger>();
    private List<BigInteger> availableReleases = new ArrayList<BigInteger>();
    private BigInteger mostRecentFeatureRelease;
    private BigInteger mostRecentLTSRelease;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AOV3AvailableReleasesType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AOV3AvailableReleasesType instance) {
      Objects.requireNonNull(instance, "instance");
      addAllAvailableLTSReleases(instance.availableLTSReleases());
      addAllAvailableReleases(instance.availableReleases());
      setMostRecentFeatureRelease(instance.mostRecentFeatureRelease());
      setMostRecentLTSRelease(instance.mostRecentLTSRelease());
      return this;
    }

    /**
     * Adds one element to {@link AOV3AvailableReleasesType#availableLTSReleases() availableLTSReleases} list.
     * @param element A availableLTSReleases element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAvailableLTSReleases(BigInteger element) {
      this.availableLTSReleases.add(Objects.requireNonNull(element, "availableLTSReleases element"));
      return this;
    }

    /**
     * Adds elements to {@link AOV3AvailableReleasesType#availableLTSReleases() availableLTSReleases} list.
     * @param elements An array of availableLTSReleases elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAvailableLTSReleases(BigInteger... elements) {
      for (BigInteger element : elements) {
        this.availableLTSReleases.add(Objects.requireNonNull(element, "availableLTSReleases element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AOV3AvailableReleasesType#availableLTSReleases() availableLTSReleases} list.
     * @param elements An iterable of availableLTSReleases elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAvailableLTSReleases(Iterable<? extends BigInteger> elements) {
      this.availableLTSReleases.clear();
      return addAllAvailableLTSReleases(elements);
    }

    /**
     * Adds elements to {@link AOV3AvailableReleasesType#availableLTSReleases() availableLTSReleases} list.
     * @param elements An iterable of availableLTSReleases elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAvailableLTSReleases(Iterable<? extends BigInteger> elements) {
      for (BigInteger element : elements) {
        this.availableLTSReleases.add(Objects.requireNonNull(element, "availableLTSReleases element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AOV3AvailableReleasesType#availableReleases() availableReleases} list.
     * @param element A availableReleases element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAvailableReleases(BigInteger element) {
      this.availableReleases.add(Objects.requireNonNull(element, "availableReleases element"));
      return this;
    }

    /**
     * Adds elements to {@link AOV3AvailableReleasesType#availableReleases() availableReleases} list.
     * @param elements An array of availableReleases elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAvailableReleases(BigInteger... elements) {
      for (BigInteger element : elements) {
        this.availableReleases.add(Objects.requireNonNull(element, "availableReleases element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AOV3AvailableReleasesType#availableReleases() availableReleases} list.
     * @param elements An iterable of availableReleases elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAvailableReleases(Iterable<? extends BigInteger> elements) {
      this.availableReleases.clear();
      return addAllAvailableReleases(elements);
    }

    /**
     * Adds elements to {@link AOV3AvailableReleasesType#availableReleases() availableReleases} list.
     * @param elements An iterable of availableReleases elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAvailableReleases(Iterable<? extends BigInteger> elements) {
      for (BigInteger element : elements) {
        this.availableReleases.add(Objects.requireNonNull(element, "availableReleases element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3AvailableReleasesType#mostRecentFeatureRelease() mostRecentFeatureRelease} attribute.
     * @param mostRecentFeatureRelease The value for mostRecentFeatureRelease 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMostRecentFeatureRelease(BigInteger mostRecentFeatureRelease) {
      this.mostRecentFeatureRelease = Objects.requireNonNull(mostRecentFeatureRelease, "mostRecentFeatureRelease");
      initBits &= ~INIT_BIT_MOST_RECENT_FEATURE_RELEASE;
      return this;
    }

    /**
     * Initializes the value for the {@link AOV3AvailableReleasesType#mostRecentLTSRelease() mostRecentLTSRelease} attribute.
     * @param mostRecentLTSRelease The value for mostRecentLTSRelease 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMostRecentLTSRelease(BigInteger mostRecentLTSRelease) {
      this.mostRecentLTSRelease = Objects.requireNonNull(mostRecentLTSRelease, "mostRecentLTSRelease");
      initBits &= ~INIT_BIT_MOST_RECENT_L_T_S_RELEASE;
      return this;
    }

    /**
     * Builds a new {@link AOV3AvailableReleases AOV3AvailableReleases}.
     * @return An immutable instance of AOV3AvailableReleases
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AOV3AvailableReleases build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AOV3AvailableReleases(
          createUnmodifiableList(true, availableLTSReleases),
          createUnmodifiableList(true, availableReleases),
          mostRecentFeatureRelease,
          mostRecentLTSRelease);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MOST_RECENT_FEATURE_RELEASE) != 0) attributes.add("mostRecentFeatureRelease");
      if ((initBits & INIT_BIT_MOST_RECENT_L_T_S_RELEASE) != 0) attributes.add("mostRecentLTSRelease");
      return "Cannot build AOV3AvailableReleases, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
