/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.util.ArrayList;
import java.util.Objects;
import net.adoptopenjdk.v3.api.AOV3Binary;
import net.adoptopenjdk.v3.api.AOV3ListBinaryAssetViewType;

public final class AOV3ListBinaryAssetView
implements AOV3ListBinaryAssetViewType {
    private final AOV3Binary binary;
    private final String releaseName;

    private AOV3ListBinaryAssetView(AOV3Binary binary, String releaseName) {
        this.binary = binary;
        this.releaseName = releaseName;
    }

    @Override
    public AOV3Binary binary() {
        return this.binary;
    }

    @Override
    public String releaseName() {
        return this.releaseName;
    }

    public final AOV3ListBinaryAssetView withBinary(AOV3Binary value) {
        if (this.binary == value) {
            return this;
        }
        AOV3Binary newValue = Objects.requireNonNull(value, "binary");
        return new AOV3ListBinaryAssetView(newValue, this.releaseName);
    }

    public final AOV3ListBinaryAssetView withReleaseName(String value) {
        String newValue = Objects.requireNonNull(value, "releaseName");
        if (this.releaseName.equals(newValue)) {
            return this;
        }
        return new AOV3ListBinaryAssetView(this.binary, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AOV3ListBinaryAssetView && this.equalTo((AOV3ListBinaryAssetView)another);
    }

    private boolean equalTo(AOV3ListBinaryAssetView another) {
        return this.binary.equals(another.binary) && this.releaseName.equals(another.releaseName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.binary.hashCode();
        h += (h << 5) + this.releaseName.hashCode();
        return h;
    }

    public String toString() {
        return "AOV3ListBinaryAssetView{binary=" + this.binary + ", releaseName=" + this.releaseName + "}";
    }

    public static AOV3ListBinaryAssetView copyOf(AOV3ListBinaryAssetViewType instance) {
        if (instance instanceof AOV3ListBinaryAssetView) {
            return (AOV3ListBinaryAssetView)instance;
        }
        return AOV3ListBinaryAssetView.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BINARY = 1L;
        private static final long INIT_BIT_RELEASE_NAME = 2L;
        private long initBits = 3L;
        private AOV3Binary binary;
        private String releaseName;

        private Builder() {
        }

        public final Builder from(AOV3ListBinaryAssetViewType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setBinary(instance.binary());
            this.setReleaseName(instance.releaseName());
            return this;
        }

        public final Builder setBinary(AOV3Binary binary) {
            this.binary = Objects.requireNonNull(binary, "binary");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setReleaseName(String releaseName) {
            this.releaseName = Objects.requireNonNull(releaseName, "releaseName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public AOV3ListBinaryAssetView build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AOV3ListBinaryAssetView(this.binary, this.releaseName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("binary");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("releaseName");
            }
            return "Cannot build AOV3ListBinaryAssetView, some of required attributes are not set " + attributes;
        }
    }
}

