/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.public_group;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsPaginatedContentDownloadResponseV2;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetGroupContentsV2
extends Operation {
    private String path = "/ugc/v2/public/namespaces/{namespace}/users/{userId}/groups/{groupId}/contents";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json", "application/octet-stream");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String groupId;
    private String namespace;
    private String userId;
    private Integer limit;
    private Integer offset;

    @Deprecated
    public PublicGetGroupContentsV2(String groupId, String namespace, String userId, Integer limit, Integer offset) {
        this.groupId = groupId;
        this.namespace = namespace;
        this.userId = userId;
        this.limit = limit;
        this.offset = offset;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.groupId != null) {
            pathParams.put("groupId", this.groupId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.groupId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelsPaginatedContentDownloadResponseV2 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsPaginatedContentDownloadResponseV2().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("offset", "None");
        return result;
    }

    public static PublicGetGroupContentsV2Builder builder() {
        return new PublicGetGroupContentsV2Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class PublicGetGroupContentsV2Builder {
        private String groupId;
        private String namespace;
        private String userId;
        private Integer limit;
        private Integer offset;

        PublicGetGroupContentsV2Builder() {
        }

        public PublicGetGroupContentsV2Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public PublicGetGroupContentsV2Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetGroupContentsV2Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicGetGroupContentsV2Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicGetGroupContentsV2Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicGetGroupContentsV2 build() {
            return new PublicGetGroupContentsV2(this.groupId, this.namespace, this.userId, this.limit, this.offset);
        }

        public String toString() {
            return "PublicGetGroupContentsV2.PublicGetGroupContentsV2Builder(groupId=" + this.groupId + ", namespace=" + this.namespace + ", userId=" + this.userId + ", limit=" + this.limit + ", offset=" + this.offset + ")";
        }
    }
}

